/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.othereicooldowns.cooldown;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.cooldowns.Cooldown;
import com.ssomar.score.features.custom.cooldowns.CooldownsManager;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ExecutableItemFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithActivators;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OtherEICooldown
extends FeatureWithHisOwnEditor<OtherEICooldown, OtherEICooldown, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private ExecutableItemFeature executableItemFeature;
    private ListUncoloredStringFeature activatorsList;
    private IntegerFeature cooldown;
    private BooleanFeature isCooldownInTicks;
    private String id;

    public OtherEICooldown(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.otherEICooldowns);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.executableItemFeature = new ExecutableItemFeature(this, FeatureSettingsSCore.executableItem);
        this.executableItemFeature.setDisableDoubleClick(true);
        this.activatorsList = new ListUncoloredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.cooldown_activators, Optional.empty());
        this.cooldown = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.cooldown);
        this.isCooldownInTicks = new BooleanFeature(this, false, FeatureSettingsSCore.isCooldownInTicks);
    }

    public void addOtherCooldowns(@NotNull Player player, @Nullable StringPlaceholder sp) {
        block6: {
            if (!((Optional)this.executableItemFeature.getValue()).isPresent()) break block6;
            SObject ei = (SObject)((Optional)this.executableItemFeature.getValue()).get();
            if (!(ei instanceof SObjectWithActivators)) {
                return;
            }
            SObjectWithActivators sObjectWithActivators = (SObjectWithActivators)((Object)ei);
            if (this.activatorsList.getValue().contains("ALL")) {
                Iterator<SActivator> iterator = sObjectWithActivators.getActivators().getActivators().values().iterator();
                while (iterator.hasNext()) {
                    SActivator act;
                    SActivator sActivator = act = iterator.next();
                    Cooldown cooldown = new Cooldown((SPlugin)ExecutableItems.plugin, ei, sActivator, player.getUniqueId(), this.cooldown.getValue(player.getUniqueId(), sp).get(), this.isCooldownInTicks.getValue(), System.currentTimeMillis(), false);
                    CooldownsManager.getInstance().addCooldown(cooldown);
                }
            } else {
                Iterator iterator = this.activatorsList.getValue().iterator();
                while (iterator.hasNext()) {
                    String activator = (String)iterator.next();
                    for (SActivator act : sObjectWithActivators.getActivators().getActivators().values()) {
                        SActivator sActivator = act;
                        if (!activator.equals(sActivator.getId())) continue;
                        Cooldown cooldown = new Cooldown((SPlugin)ExecutableItems.plugin, ei, sActivator, player.getUniqueId(), this.cooldown.getValue(player.getUniqueId(), sp).get(), this.isCooldownInTicks.getValue(), System.currentTimeMillis(), false);
                        CooldownsManager.getInstance().addCooldown(cooldown);
                    }
                }
            }
        }
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(){
            {
                this.add(OtherEICooldown.this.executableItemFeature);
                this.add(OtherEICooldown.this.activatorsList);
                this.add(OtherEICooldown.this.cooldown);
                this.add(OtherEICooldown.this.isCooldownInTicks);
            }
        };
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return null;
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            OtherEICooldown c;
            if (!(feature instanceof OtherEICooldown) || !(c = (OtherEICooldown)feature).getId().equals(this.id)) continue;
            c.setExecutableItemFeature(this.executableItemFeature);
            c.setActivatorsList(this.activatorsList);
            c.setCooldown(this.cooldown);
            c.setIsCooldownInTicks(this.isCooldownInTicks);
            c.reloadActivatorsSuggestions();
            break;
        }
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public List<String> load(SPlugin sPlugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.executableItemFeature.load(sPlugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.activatorsList.load(sPlugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.cooldown.load(sPlugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.isCooldownInTicks.load(sPlugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the OtherEICooldown with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    public void reloadActivatorsSuggestions() {
        if (((Optional)this.executableItemFeature.getValue()).isPresent()) {
            ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
            for (SActivator act : ((ExecutableItemInterface)((Optional)this.executableItemFeature.getValue()).get()).getActivators().getActivators().values()) {
                suggestions.add(new Suggestion(act.getId(), "&6[&e" + act.getId() + "&6]", "&7Add &e" + act.getId()));
            }
            suggestions.add(new Suggestion("ALL", "&8[&7Add ALL&8]", "&7Add &eALL"));
            this.activatorsList.setSuggestions(Optional.of(suggestions));
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.executableItemFeature.save(attributeConfig);
        this.activatorsList.save(attributeConfig);
        this.cooldown.save(attributeConfig);
        this.isCooldownInTicks.save(attributeConfig);
    }

    @Override
    public OtherEICooldown getValue() {
        return this;
    }

    @Override
    public OtherEICooldown initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 5];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = ((Optional)this.executableItemFeature.getValue()).isPresent() ? "&7EI ID: &e" + ((ExecutableItemInterface)((Optional)this.executableItemFeature.getValue()).get()).getId() : "&7EI ID: &cNone";
        finalDescription[finalDescription.length - 4] = "&7Activators: &e" + this.activatorsList.getValue().size();
        finalDescription[finalDescription.length - 3] = "&7Cooldown: &e" + ((Optional)this.cooldown.getValue()).get();
        finalDescription[finalDescription.length - 2] = "&7Cooldown in ticks: &e" + this.isCooldownInTicks.getValue();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public OtherEICooldown clone(FeatureParentInterface newParent) {
        this.reloadActivatorsSuggestions();
        OtherEICooldown otherEICooldown = new OtherEICooldown(newParent, this.id);
        otherEICooldown.executableItemFeature = this.executableItemFeature.clone(otherEICooldown);
        otherEICooldown.activatorsList = this.activatorsList.clone(otherEICooldown);
        otherEICooldown.cooldown = this.cooldown.clone(otherEICooldown);
        otherEICooldown.isCooldownInTicks = this.isCooldownInTicks.clone(otherEICooldown);
        return otherEICooldown;
    }

    @Generated
    public ExecutableItemFeature getExecutableItemFeature() {
        return this.executableItemFeature;
    }

    @Generated
    public ListUncoloredStringFeature getActivatorsList() {
        return this.activatorsList;
    }

    @Generated
    public IntegerFeature getCooldown() {
        return this.cooldown;
    }

    @Generated
    public BooleanFeature getIsCooldownInTicks() {
        return this.isCooldownInTicks;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setExecutableItemFeature(ExecutableItemFeature executableItemFeature) {
        this.executableItemFeature = executableItemFeature;
    }

    @Generated
    public void setActivatorsList(ListUncoloredStringFeature activatorsList) {
        this.activatorsList = activatorsList;
    }

    @Generated
    public void setCooldown(IntegerFeature cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setIsCooldownInTicks(BooleanFeature isCooldownInTicks) {
        this.isCooldownInTicks = isCooldownInTicks;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

