/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.ssomar.score.SCore;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomFurniture;
import dev.lone.itemsadder.api.CustomStack;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class ItemsAdderAPI {
    public static boolean breakCustomBlock(final Block block, ItemStack item, boolean drop) {
        if (SCore.hasItemsAdder && block != null && !block.isEmpty()) {
            CustomBlock customBlock;
            if (SCore.hasClass("dev.lone.itemsadder.api.CustomBlock") && (customBlock = CustomBlock.byAlreadyPlaced((Block)block)) != null) {
                if (drop) {
                    List loots = customBlock.getLoot(item, false);
                    for (ItemStack loot : loots) {
                        block.getWorld().dropItemNaturally(block.getLocation(), loot);
                    }
                }
                customBlock.playBreakSound();
                customBlock.playBreakEffect();
                customBlock.playBreakParticles();
                customBlock.remove();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        block.setType(Material.AIR);
                    }
                };
                SCore.schedulerHook.runTask(runnable, 1L);
                return true;
            }
            for (Entity e : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5)) {
                ArmorStand armorStand;
                if (!(e instanceof ArmorStand) || (armorStand = (ArmorStand)e).getCustomName() == null || !armorStand.getCustomName().equals("ItemsAdder_furniture")) continue;
                CustomFurniture furniture = CustomFurniture.byAlreadySpawned((Entity)armorStand);
                furniture.remove(drop);
                return true;
            }
        }
        return false;
    }

    public static Optional<String> getCustomBlockID(Block block) {
        if (SCore.hasItemsAdder && block != null && !block.isEmpty()) {
            CustomBlock customBlock;
            if (SCore.hasClass("dev.lone.itemsadder.api.CustomBlock") && (customBlock = CustomBlock.byAlreadyPlaced((Block)block)) != null) {
                return Optional.of(customBlock.getId());
            }
            for (Entity e : block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5)) {
                ArmorStand armorStand;
                if (!(e instanceof ArmorStand) || (armorStand = (ArmorStand)e).getCustomName() == null || !armorStand.getCustomName().equals("ItemsAdder_furniture")) continue;
                return Optional.of(CustomFurniture.byAlreadySpawned((Entity)armorStand).getId());
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getCustomItemID(ItemStack item) {
        CustomStack customStack;
        if (SCore.hasItemsAdder && item != null && (customStack = CustomStack.byItemStack((ItemStack)item)) != null) {
            return Optional.of(customStack.getId());
        }
        return Optional.empty();
    }

    public static boolean isCustomBlock(Block block) {
        return ItemsAdderAPI.getCustomBlockID(block).isPresent();
    }

    public static boolean isCustomItem(ItemStack item) {
        return ItemsAdderAPI.getCustomItemID(item).isPresent();
    }

    public static boolean placeItemAdder(Location location, String id) {
        try {
            CustomBlock customBlock = CustomBlock.getInstance((String)id);
            if (customBlock != null) {
                customBlock.place(location);
                return true;
            }
        }
        catch (Error | Exception e) {
            try {
                CustomFurniture.spawnPreciseNonSolid((String)id, (Location)location);
                return true;
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

