/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.ssomar.score.SCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MyCoreProtectAPI {
    public static void logRemoval(String user, Location location, Material type, BlockData blockData) {
        if (SCore.hasCoreProtect) {
            Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CoreProtect");
            if (!plugin.isEnabled()) {
                return;
            }
            if (!(plugin instanceof CoreProtect)) {
                return;
            }
            CoreProtectAPI CoreProtect2 = ((CoreProtect)plugin).getAPI();
            if (!CoreProtect2.isEnabled()) {
                return;
            }
            if (CoreProtect2.APIVersion() < 9) {
                return;
            }
            CoreProtect2.logRemoval(user, location, type, blockData);
        }
    }

    public static boolean isNaturalBlock(Block block) {
        if (SCore.hasCoreProtect) {
            Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CoreProtect");
            if (!plugin.isEnabled()) {
                return false;
            }
            if (!(plugin instanceof CoreProtect)) {
                return false;
            }
            CoreProtectAPI CoreProtect2 = ((CoreProtect)plugin).getAPI();
            if (!CoreProtect2.isEnabled()) {
                return false;
            }
            if (CoreProtect2.APIVersion() < 9) {
                return false;
            }
            List list = CoreProtect2.blockLookup(block, 2592000);
            return list.size() == 0;
        }
        return false;
    }

    public void addPickup(Location location, ItemStack itemStack, Player player) {
        if (SCore.hasCoreProtect) {
            Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("CoreProtect");
            if (plugin != null && !plugin.isEnabled()) {
                return;
            }
            if (!(plugin instanceof CoreProtect)) {
                return;
            }
            CoreProtectAPI CoreProtect2 = ((CoreProtect)plugin).getAPI();
            if (!CoreProtect2.isEnabled()) {
                return;
            }
            if (CoreProtect2.APIVersion() < 9) {
                return;
            }
            if (!Config.getConfig((World)location.getWorld()).ITEM_PICKUPS) {
                return;
            }
            if (itemStack == null) {
                return;
            }
            String loggingItemId = player.getName().toLowerCase(Locale.ROOT) + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ();
            new Register();
            int itemId = Register.getItem(loggingItemId);
            List list = ConfigHandler.itemsPickup.getOrDefault(loggingItemId, new ArrayList());
            list.add(itemStack.clone());
            ConfigHandler.itemsPickup.put(loggingItemId, list);
            int time = (int)(System.currentTimeMillis() / 1000L) + 1;
            new Register().addItemTransaction(player, location.clone(), time, itemId);
        }
    }

    static class Register
    extends Queue {
        public static int getItem(String loggingItemId) {
            return Register.getItemId((String)loggingItemId);
        }

        public void addItemTransaction(Player player, Location location, int time, int itemId) {
            Queue.queueItemTransaction((String)player.getName(), (Location)location.clone(), (int)time, (int)0, (int)itemId);
        }
    }
}

