/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.display;

import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.display.DisplayPriority;
import com.ssomar.score.utils.display.DisplayProperties;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayModule {
    private final int weight;
    private final SPlugin plugin;
    private List<String> loadedIDs;

    protected DisplayModule(@NotNull SPlugin plugin, @NotNull DisplayPriority priority) {
        this(plugin, priority.getWeight());
        this.loadedIDs = new ArrayList<String>();
    }

    protected DisplayModule(@NotNull SPlugin plugin, int weight) {
        this.plugin = plugin;
        this.weight = weight;
        this.loadedIDs = new ArrayList<String>();
    }

    public boolean display(@NotNull ItemStack itemStack) {
        return false;
    }

    public boolean display(@NotNull ItemStack itemStack, @Nullable Player player) {
        return false;
    }

    public boolean display(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull DisplayProperties properties) {
        return false;
    }

    public void revert(@NotNull ItemStack itemStack) {
    }

    public final String getPluginName() {
        return this.getPlugin().getName();
    }

    public int getWeight() {
        return this.weight;
    }

    public SPlugin getPlugin() {
        return this.plugin;
    }

    public List<String> getLoadedIDs() {
        return this.loadedIDs;
    }

    public void addLoadedID(String id) {
        if (!this.loadedIDs.contains(id)) {
            this.loadedIDs.add(id);
        }
    }

    public String getLoadedIDsString() {
        StringBuilder result = new StringBuilder();
        for (String id : this.loadedIDs) {
            result.append(id).append(", ");
        }
        if (result.length() > 2) {
            result = new StringBuilder(result.substring(0, result.length() - 2));
        }
        return result.toString();
    }
}

