/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.numbers;

import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class NTools
implements Serializable {
    public static DecimalFormat numberFormat_1 = new DecimalFormat("#.0", DecimalFormatSymbols.getInstance(Locale.US));
    public static DecimalFormat numberFormat_2 = new DecimalFormat("#.00", DecimalFormatSymbols.getInstance(Locale.US));
    public static DecimalFormat numberFormat_3 = new DecimalFormat("#.000", DecimalFormatSymbols.getInstance(Locale.US));
    private static final ConcurrentHashMap<Integer, DecimalFormat> FORMATTER_CACHE = new ConcurrentHashMap();

    public static Optional<Integer> getInteger(String s) {
        Optional<Integer> result = Optional.empty();
        try {
            result = Optional.of(Integer.valueOf(s));
        }
        catch (NumberFormatException e) {
            return result;
        }
        return result;
    }

    public static Optional<Double> getDouble(String s) {
        Optional<Double> result = Optional.empty();
        try {
            result = Optional.of(Double.valueOf(s));
        }
        catch (NumberFormatException e) {
            return result;
        }
        return result;
    }

    public static Optional<Long> getLong(String s) {
        Optional<Long> result = Optional.empty();
        try {
            result = Optional.of(Long.valueOf(s));
        }
        catch (NumberFormatException e) {
            return result;
        }
        return result;
    }

    public static Optional<Float> getFloat(String s) {
        Optional<Float> result = Optional.empty();
        try {
            result = Optional.of(Float.valueOf(s));
        }
        catch (NumberFormatException e) {
            return result;
        }
        return result;
    }

    public static boolean isNumber(String s) {
        try {
            Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static double reduceDouble(@NotNull double number, int numbersAfterComma) {
        if (numbersAfterComma >= 0) {
            double factor = Math.pow(10.0, numbersAfterComma);
            return (double)Math.round(number * factor) / factor;
        }
        return NTools.formatWithDecimalFormat(number, numbersAfterComma);
    }

    private static double formatWithDecimalFormat(double number, int numbersAfterComma) {
        DecimalFormat formatter = FORMATTER_CACHE.computeIfAbsent(numbersAfterComma, precision -> {
            StringBuilder pattern = new StringBuilder("#.");
            for (int i = 0; i < precision; ++i) {
                pattern.append("0");
            }
            DecimalFormat df = new DecimalFormat(pattern.toString(), DecimalFormatSymbols.getInstance(Locale.US));
            df.setRoundingMode(RoundingMode.HALF_UP);
            return df;
        });
        return Double.parseDouble(formatter.format(number));
    }

    public static void main(String[] args) {
        System.out.println(NTools.reduceDouble(1.87656789, 2));
    }

    static {
        for (int i = 1; i <= 3; ++i) {
            FORMATTER_CACHE.computeIfAbsent(i, precision -> {
                StringBuilder pattern = new StringBuilder("#.");
                for (int j = 0; j < precision; ++j) {
                    pattern.append("0");
                }
                DecimalFormat df = new DecimalFormat(pattern.toString(), DecimalFormatSymbols.getInstance(Locale.US));
                df.setRoundingMode(RoundingMode.HALF_UP);
                return df;
            });
        }
    }
}

