/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.strings;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.utils.Couple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringSetting {
    public static Map<String, Object> extractSettingsAndRebuildCorrectly(List<String> args, int startIndex, List<String> startToIgnore) {
        ArrayList<String> rebuildArgs = new ArrayList<String>();
        StringBuilder potentialInput = new StringBuilder();
        int index = 0;
        for (String arg : args) {
            if (index >= startIndex) {
                potentialInput.append(arg).append(" ");
            } else {
                rebuildArgs.add(arg);
            }
            ++index;
        }
        if (potentialInput.length() > 0) {
            potentialInput.deleteCharAt(potentialInput.length() - 1);
        }
        Couple<Map<String, Object>, String> couple = StringSetting.extractSettings(potentialInput.toString(), startToIgnore);
        rebuildArgs.addAll(Arrays.asList(couple.getElem2().split(" ")));
        args.clear();
        args.addAll(rebuildArgs);
        return couple.getElem1();
    }

    public static Couple<Map<String, Object>, String> extractSettings(String input, List<String> startToIgnore) {
        input = input.trim();
        String start = "";
        for (String sToIgnore : startToIgnore) {
            if (!input.startsWith(sToIgnore)) continue;
            input = input.substring(sToIgnore.length());
            start = sToIgnore;
            break;
        }
        int breakAtNextClosure = 0;
        StringBuilder sb = new StringBuilder(start);
        StringBuilder sbSettings = new StringBuilder();
        boolean isOutSideSettings = true;
        boolean finished = false;
        for (char c : input.toCharArray()) {
            if (isOutSideSettings) {
                sb.append(c);
            } else {
                sbSettings.append(c);
            }
            if (finished) continue;
            if (isOutSideSettings) {
                if (c == ' ') {
                    finished = true;
                    continue;
                }
                if (c != '{') continue;
                isOutSideSettings = false;
                sb.deleteCharAt(sb.length() - 1);
                continue;
            }
            if (c == '{') {
                ++breakAtNextClosure;
                continue;
            }
            if (c != '}') continue;
            if (breakAtNextClosure == 0) {
                finished = true;
                isOutSideSettings = true;
                continue;
            }
            --breakAtNextClosure;
        }
        if (sbSettings.length() >= 1) {
            sbSettings.deleteCharAt(sbSettings.length() - 1);
        }
        SsomarDev.testMsg("sb: " + sb, true);
        SsomarDev.testMsg("sbSettings: " + sbSettings, true);
        Couple<Map<String, Object>, String> result = new Couple<Map<String, Object>, String>(StringSetting.getSettings(sbSettings.toString()), sb.toString());
        return result;
    }

    public static Map<String, Object> getSettings(String input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        input = input.trim();
        String savedKey = "";
        StringBuilder sb = new StringBuilder();
        boolean inList = false;
        boolean inMap = false;
        boolean inKey = true;
        boolean inText = false;
        boolean inLongText = false;
        int breakAtNextClosure = 0;
        for (char c : input.toCharArray()) {
            sb.append(c);
            if (c == '[') {
                if (inList) {
                    ++breakAtNextClosure;
                }
                inList = true;
                continue;
            }
            if (c == ']') {
                if (!inList) continue;
                if (breakAtNextClosure == 0) {
                    inList = false;
                    result.put(savedKey, StringSetting.loadList(sb.deleteCharAt(0).deleteCharAt(sb.length() - 1).toString()));
                    savedKey = "";
                    sb.setLength(0);
                    continue;
                }
                --breakAtNextClosure;
                continue;
            }
            if (c == '\"') {
                if (inLongText) {
                    inLongText = false;
                    result.put(savedKey, sb.deleteCharAt(0).deleteCharAt(sb.length() - 1).toString());
                    savedKey = "";
                    sb.setLength(0);
                    continue;
                }
                if (inMap || inList) continue;
                inLongText = true;
                continue;
            }
            if (c == '{') {
                if (inMap) {
                    ++breakAtNextClosure;
                }
                inMap = true;
                continue;
            }
            if (c == '}') {
                if (!inMap) continue;
                if (breakAtNextClosure == 0) {
                    inMap = false;
                    result.put(savedKey, StringSetting.getSettings(sb.deleteCharAt(0).deleteCharAt(sb.length() - 1).toString()));
                    savedKey = "";
                    sb.setLength(0);
                    continue;
                }
                --breakAtNextClosure;
                continue;
            }
            if (c == ':') {
                if (!inKey) continue;
                savedKey = sb.deleteCharAt(sb.length() - 1).toString();
                sb.setLength(0);
                inKey = false;
                continue;
            }
            if (c == ',') {
                if (inText) {
                    result.put(savedKey, sb.deleteCharAt(sb.length() - 1).toString());
                    savedKey = "";
                    sb.setLength(0);
                    inText = false;
                }
                if (inList || inMap || inText || inLongText || inKey) continue;
                sb.setLength(0);
                inKey = true;
                continue;
            }
            if (inList || inMap || inText || inLongText || inKey) continue;
            inText = true;
        }
        if (inText) {
            result.put(savedKey, sb.toString());
        }
        Object object = result.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            SsomarDev.testMsg("Variableeeeeeeeee > " + (String)entry.getKey() + " -> " + entry.getValue(), true);
        }
        return result;
    }

    private static List<String> loadList(String s) {
        return Arrays.asList(s.split(","));
    }

    public static void main(String[] args) {
        StringSetting test = new StringSetting();
        String input = "Var:{var1:value1,var2:\"value2,  et\"},Usage:1, Test:[hello,hhhh]";
        Map<String, Object> settings = StringSetting.getSettings(input);
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            System.out.println(entry.getKey() + " -> " + entry.getValue());
        }
        String input2 = "xxxxfrikd:{Var:{var1:value1,var2:\"value2,  et\"},Usage:1, Test:[hello,hhhh]} other_arg 145";
        Couple<Map<String, Object>, String> couple = StringSetting.extractSettings(input2, new ArrayList<String>());
        System.out.println("String without settings: " + couple.getElem2());
    }
}

