/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.writer;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.score.SCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class NameSpaceKeyWriterReader {
    public static String readAllInfo(PersistentDataContainer dataContainer) {
        StringBuilder sb = new StringBuilder();
        for (NamespacedKey key : dataContainer.getKeys()) {
            sb.append(key.getKey()).append(": ");
            try {
                sb.append((String)dataContainer.get(key, PersistentDataType.STRING)).append("\n");
            }
            catch (IllegalArgumentException e) {
                try {
                    sb.append(dataContainer.get(key, PersistentDataType.INTEGER)).append("\n");
                }
                catch (IllegalArgumentException e2) {
                    try {
                        sb.append(dataContainer.get(key, PersistentDataType.DOUBLE)).append("\n");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        return sb.toString();
    }

    public static void writeString(Plugin splugin, PersistentDataContainer dataContainer, String key, String value) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        dataContainer.set(key3, PersistentDataType.STRING, (Object)value);
    }

    public static void writeStringIfNull(Plugin splugin, PersistentDataContainer dataContainer, String key, String value) {
        NamespacedKey key4 = new NamespacedKey(splugin, key);
        try {
            if (dataContainer.get(key4, PersistentDataType.STRING) == null) {
                dataContainer.set(key4, PersistentDataType.STRING, (Object)value);
            }
        }
        catch (IllegalArgumentException e) {
            dataContainer.set(key4, PersistentDataType.STRING, (Object)value);
        }
    }

    public static Optional<String> readString(Plugin splugin, PersistentDataContainer dataContainer, String key) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        return Optional.ofNullable((String)dataContainer.get(key3, PersistentDataType.STRING));
    }

    public static void writeInteger(Plugin splugin, PersistentDataContainer dataContainer, String key, int value) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        dataContainer.set(key3, PersistentDataType.INTEGER, (Object)value);
    }

    public static void writeIntegerIfNull(Plugin splugin, PersistentDataContainer dataContainer, String key, int value) {
        NamespacedKey key4 = new NamespacedKey(splugin, key);
        try {
            if (dataContainer.get(key4, PersistentDataType.INTEGER) == null) {
                dataContainer.set(key4, PersistentDataType.INTEGER, (Object)value);
            }
        }
        catch (IllegalArgumentException e) {
            dataContainer.set(key4, PersistentDataType.INTEGER, (Object)value);
        }
    }

    public static Optional<Integer> readInteger(Plugin splugin, PersistentDataContainer dataContainer, String key) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        return Optional.ofNullable((Integer)dataContainer.get(key3, PersistentDataType.INTEGER));
    }

    public static void writeDouble(Plugin splugin, PersistentDataContainer dataContainer, String key, double value) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        dataContainer.set(key3, PersistentDataType.DOUBLE, (Object)value);
    }

    public static void writeDoubleIfNull(Plugin splugin, PersistentDataContainer dataContainer, String key, double value) {
        NamespacedKey key4 = new NamespacedKey(splugin, key);
        try {
            if (dataContainer.get(key4, PersistentDataType.DOUBLE) == null) {
                dataContainer.set(key4, PersistentDataType.DOUBLE, (Object)value);
            }
        }
        catch (IllegalArgumentException e) {
            dataContainer.set(key4, PersistentDataType.DOUBLE, (Object)value);
        }
    }

    public static Optional<Double> readDouble(Plugin splugin, PersistentDataContainer dataContainer, String key) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        return Optional.ofNullable((Double)dataContainer.get(key3, PersistentDataType.DOUBLE));
    }

    public static void writeList(Plugin splugin, PersistentDataContainer dataContainer, String key, List<String> value) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        dataContainer.set(key3, PersistentDataType.STRING, (Object)value.toString());
    }

    public static void writeListIfNull(Plugin splugin, PersistentDataContainer dataContainer, String key, List<String> value) {
        NamespacedKey key4 = new NamespacedKey(splugin, key);
        try {
            if (dataContainer.get(key4, PersistentDataType.STRING) == null) {
                dataContainer.set(key4, PersistentDataType.STRING, (Object)value.toString());
            }
        }
        catch (IllegalArgumentException e) {
            dataContainer.set(key4, PersistentDataType.STRING, (Object)value.toString());
        }
    }

    public static Optional<List<String>> readList(Plugin splugin, PersistentDataContainer dataContainer, String key) {
        NamespacedKey key3 = new NamespacedKey(splugin, key);
        String s = (String)dataContainer.get(key3, PersistentDataType.STRING);
        if (s != null) {
            return Optional.of(new ArrayList<String>(Arrays.asList(s.substring(1, s.length() - 1).split(", "))));
        }
        return Optional.empty();
    }

    public static void removeKey(Plugin splugin, PersistentDataContainer dataContainer, String key) {
        NamespacedKey key1 = new NamespacedKey(splugin, key);
        dataContainer.remove(key1);
    }

    public static Optional<UUID> readItemOwner(PersistentDataContainer dataContainer) {
        NamespacedKey key;
        String ownerUUIDStr;
        if (SCore.hasExecutableItems && (ownerUUIDStr = (String)dataContainer.get(key = new NamespacedKey((Plugin)ExecutableItems.getPluginSt(), "EI-OWNER"), PersistentDataType.STRING)) != null) {
            try {
                return Optional.ofNullable(UUID.fromString(ownerUUIDStr));
            }
            catch (IllegalArgumentException e) {
                return Optional.ofNullable(null);
            }
        }
        return Optional.ofNullable(null);
    }
}

