/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.click.left;

import com.ssomar.sevents.events.player.click.TooManyInteractionManager;
import com.ssomar.sevents.events.player.click.left.PlayerLeftClickEvent;
import com.ssomar.sevents.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class PlayerLeftClickListener
implements Listener {
    private final List<UUID> cancelInteraction = new ArrayList<UUID>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerInteractEvent(PlayerInteractEvent e) {
        int amount;
        Player p = e.getPlayer();
        UUID pUUID = p.getUniqueId();
        if (TooManyInteractionManager.getInstance().containsKey(pUUID) && (amount = ((Integer)TooManyInteractionManager.getInstance().get(pUUID)).intValue()) > 0) {
            if (amount == 1) {
                TooManyInteractionManager.getInstance().remove(pUUID);
            } else {
                TooManyInteractionManager.getInstance().put(pUUID, amount - 1);
            }
            return;
        }
        if (this.cancelInteraction.contains(pUUID)) {
            this.cancelInteraction.removeAll(Collections.singleton(pUUID));
            e.setCancelled(true);
            return;
        }
        Action action = e.getAction();
        if (action.equals((Object)Action.PHYSICAL)) {
            return;
        }
        if (action.equals((Object)Action.LEFT_CLICK_AIR) || action.equals((Object)Action.LEFT_CLICK_BLOCK)) {
            PlayerLeftClickEvent playerLeftClickEvent = new PlayerLeftClickEvent(e.getPlayer(), e.getClickedBlock(), e.getBlockFace());
            Bukkit.getServer().getPluginManager().callEvent((Event)playerLeftClickEvent);
            if (playerLeftClickEvent.isCancelled()) {
                e.setCancelled(true);
                e.setUseItemInHand(Event.Result.DENY);
                e.setUseInteractedBlock(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDropItemEvent(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (!Version.is1v13Less() || Version.is1v14()) {
            Location eyeLoc = p.getEyeLocation().clone();
            for (double j = 0.0; j <= 5.0; j += 0.1) {
                Vector vec = eyeLoc.getDirection();
                Location newLoc = eyeLoc.clone().add(vec.multiply(j));
                Block b2 = newLoc.getBlock();
                if (b2.isEmpty() || !b2.getBoundingBox().contains(newLoc.getX(), newLoc.getY(), newLoc.getZ())) continue;
                return;
            }
            this.cancelInteraction.add(p.getUniqueId());
            return;
        }
    }
}

