/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.SCore;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.features.custom.detailedblocks.DetailedBlocks;
import com.ssomar.score.utils.logging.Debugers;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.sevents.events.player.click.onentity.left.PlayerLeftClickOnEntityEvent;
import com.ssomar.sevents.events.player.click.onplayer.left.PlayerLeftClickOnPlayerEvent;
import com.ssomar.sevents.events.player.receivehit.byentity.PlayerReceiveHitByEntityEvent;
import com.ssomar.sevents.events.player.receivehit.byplayer.PlayerReceiveHitByPlayerEvent;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ActionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer slot;
    private transient ExecutableItemObject executableItem;
    private boolean isEventFromCustomBreakCommand;
    private transient BlockBreakEventExtension.BreakCause breakCause;
    private boolean isActionRelatedToDamageEvent;
    private UUID launcherUUID;
    private UUID receiverUUID;
    private int blockLocationX;
    private int blockLocationY;
    private int blockLocationZ;
    private UUID blockLocationWorld;
    private BlockFace blockFace;
    private DetailedBlocks detailedBlocks;
    private Material oldBlockMaterial;
    private String oldBlockMaterialName;
    private UUID entityUUID;
    private ItemStack itemStack;
    private ItemStack targetItemStack;
    private transient Optional<Vector> velocity;
    private boolean silenceOutput;
    private boolean noPlayerTriggeredTheAction;
    private StringPlaceholder sp;
    private int step;
    private Debugers debugers;

    public ActionInfo(String name, StringPlaceholder sp) {
        this.name = name;
        this.slot = -1;
        this.sp = sp;
        this.executableItem = null;
        this.isEventFromCustomBreakCommand = false;
        this.breakCause = null;
        this.launcherUUID = null;
        this.receiverUUID = null;
        this.itemStack = null;
        this.targetItemStack = null;
        this.blockLocationX = -1;
        this.blockLocationY = -1;
        this.blockLocationZ = -1;
        this.blockLocationWorld = null;
        this.blockFace = null;
        this.oldBlockMaterial = null;
        this.oldBlockMaterialName = null;
        this.entityUUID = null;
        this.silenceOutput = false;
        this.noPlayerTriggeredTheAction = false;
        this.velocity = Optional.empty();
        this.debugers = new Debugers();
        this.step = 0;
    }

    public ActionInfo clone() {
        ActionInfo result = new ActionInfo(this.name, this.sp);
        result.setExecutableItem(this.executableItem);
        result.setEventFromCustomBreakCommand(this.isEventFromCustomBreakCommand);
        result.setBreakCause(this.breakCause);
        result.setLauncherUUID(this.launcherUUID);
        result.setReceiverUUID(this.receiverUUID);
        result.setOldBlockMaterial(this.oldBlockMaterial);
        result.setOldBlockMaterialName(this.oldBlockMaterialName);
        result.setEntityUUID(this.entityUUID);
        result.setItemStack(this.itemStack);
        result.setTargetItemStack(this.targetItemStack);
        result.setSilenceOutput(this.silenceOutput);
        result.setNoPlayerTriggeredTheAction(this.noPlayerTriggeredTheAction);
        result.setBlockLocationX(this.blockLocationX);
        result.setBlockLocationY(this.blockLocationY);
        result.setBlockLocationZ(this.blockLocationZ);
        result.setBlockLocationWorld(this.blockLocationWorld);
        result.setBlockFace(this.blockFace);
        result.setDetailedBlocks(this.detailedBlocks);
        result.setVelocity(this.velocity);
        result.setStep(this.step);
        return result;
    }

    public void setBlock(final Block block) {
        Location bLoc = block.getLocation();
        this.blockLocationX = bLoc.getBlockX();
        this.blockLocationY = bLoc.getBlockY();
        this.blockLocationZ = bLoc.getBlockZ();
        this.blockLocationWorld = bLoc.getWorld().getUID();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BlockData blockData = null;
                if (block.getType().equals((Object)Material.COCOA) && (blockData = block.getBlockData()) != null) {
                    if (blockData instanceof Directional) {
                        ActionInfo.this.blockFace = ((Directional)blockData).getFacing();
                    }
                } else {
                    ActionInfo.this.blockFace = null;
                }
            }
        };
        SCore.schedulerHook.runLocationTask(runnable, bLoc, 0L);
    }

    public void initActionRelatedToDamageEvent(Event event) {
        this.isActionRelatedToDamageEvent = event instanceof EntityDamageByEntityEvent || event instanceof PlayerReceiveHitByPlayerEvent || event instanceof PlayerReceiveHitByEntityEvent || event instanceof PlayerLeftClickOnPlayerEvent || event instanceof PlayerLeftClickOnEntityEvent;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getSlot() {
        return this.slot;
    }

    @Generated
    public ExecutableItemObject getExecutableItem() {
        return this.executableItem;
    }

    @Generated
    public boolean isEventFromCustomBreakCommand() {
        return this.isEventFromCustomBreakCommand;
    }

    @Generated
    public BlockBreakEventExtension.BreakCause getBreakCause() {
        return this.breakCause;
    }

    @Generated
    public boolean isActionRelatedToDamageEvent() {
        return this.isActionRelatedToDamageEvent;
    }

    @Generated
    public UUID getLauncherUUID() {
        return this.launcherUUID;
    }

    @Generated
    public UUID getReceiverUUID() {
        return this.receiverUUID;
    }

    @Generated
    public int getBlockLocationX() {
        return this.blockLocationX;
    }

    @Generated
    public int getBlockLocationY() {
        return this.blockLocationY;
    }

    @Generated
    public int getBlockLocationZ() {
        return this.blockLocationZ;
    }

    @Generated
    public UUID getBlockLocationWorld() {
        return this.blockLocationWorld;
    }

    @Generated
    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    @Generated
    public DetailedBlocks getDetailedBlocks() {
        return this.detailedBlocks;
    }

    @Generated
    public Material getOldBlockMaterial() {
        return this.oldBlockMaterial;
    }

    @Generated
    public String getOldBlockMaterialName() {
        return this.oldBlockMaterialName;
    }

    @Generated
    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Generated
    public ItemStack getTargetItemStack() {
        return this.targetItemStack;
    }

    @Generated
    public Optional<Vector> getVelocity() {
        return this.velocity;
    }

    @Generated
    public boolean isSilenceOutput() {
        return this.silenceOutput;
    }

    @Generated
    public boolean isNoPlayerTriggeredTheAction() {
        return this.noPlayerTriggeredTheAction;
    }

    @Generated
    public StringPlaceholder getSp() {
        return this.sp;
    }

    @Generated
    public int getStep() {
        return this.step;
    }

    @Generated
    public Debugers getDebugers() {
        return this.debugers;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSlot(Integer slot) {
        this.slot = slot;
    }

    @Generated
    public void setExecutableItem(ExecutableItemObject executableItem) {
        this.executableItem = executableItem;
    }

    @Generated
    public void setEventFromCustomBreakCommand(boolean isEventFromCustomBreakCommand) {
        this.isEventFromCustomBreakCommand = isEventFromCustomBreakCommand;
    }

    @Generated
    public void setBreakCause(BlockBreakEventExtension.BreakCause breakCause) {
        this.breakCause = breakCause;
    }

    @Generated
    public void setActionRelatedToDamageEvent(boolean isActionRelatedToDamageEvent) {
        this.isActionRelatedToDamageEvent = isActionRelatedToDamageEvent;
    }

    @Generated
    public void setLauncherUUID(UUID launcherUUID) {
        this.launcherUUID = launcherUUID;
    }

    @Generated
    public void setReceiverUUID(UUID receiverUUID) {
        this.receiverUUID = receiverUUID;
    }

    @Generated
    public void setBlockLocationX(int blockLocationX) {
        this.blockLocationX = blockLocationX;
    }

    @Generated
    public void setBlockLocationY(int blockLocationY) {
        this.blockLocationY = blockLocationY;
    }

    @Generated
    public void setBlockLocationZ(int blockLocationZ) {
        this.blockLocationZ = blockLocationZ;
    }

    @Generated
    public void setBlockLocationWorld(UUID blockLocationWorld) {
        this.blockLocationWorld = blockLocationWorld;
    }

    @Generated
    public void setBlockFace(BlockFace blockFace) {
        this.blockFace = blockFace;
    }

    @Generated
    public void setDetailedBlocks(DetailedBlocks detailedBlocks) {
        this.detailedBlocks = detailedBlocks;
    }

    @Generated
    public void setOldBlockMaterial(Material oldBlockMaterial) {
        this.oldBlockMaterial = oldBlockMaterial;
    }

    @Generated
    public void setOldBlockMaterialName(String oldBlockMaterialName) {
        this.oldBlockMaterialName = oldBlockMaterialName;
    }

    @Generated
    public void setEntityUUID(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    @Generated
    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Generated
    public void setTargetItemStack(ItemStack targetItemStack) {
        this.targetItemStack = targetItemStack;
    }

    @Generated
    public void setVelocity(Optional<Vector> velocity) {
        this.velocity = velocity;
    }

    @Generated
    public void setSilenceOutput(boolean silenceOutput) {
        this.silenceOutput = silenceOutput;
    }

    @Generated
    public void setNoPlayerTriggeredTheAction(boolean noPlayerTriggeredTheAction) {
        this.noPlayerTriggeredTheAction = noPlayerTriggeredTheAction;
    }

    @Generated
    public void setSp(StringPlaceholder sp) {
        this.sp = sp;
    }

    @Generated
    public void setStep(int step) {
        this.step = step;
    }

    @Generated
    public void setDebugers(Debugers debugers) {
        this.debugers = debugers;
    }
}

