/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.commands.runnable.mixed_player_entity.commands.TeleportOnCursorManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class UnsafeTeleportOnCursor
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        if (!(receiver instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingReceiver = (LivingEntity)receiver;
        int amount = 200;
        if (args.size() >= 1 && (amount = Double.valueOf(args.get(0)).intValue()) <= 0) {
            amount = 200;
        }
        try {
            Location eyeLoc = livingReceiver.getEyeLocation();
            Vector eyeVec = eyeLoc.getDirection();
            Vector checkVec = eyeVec.clone().multiply(2);
            Location checkLoc = eyeLoc.clone().add(checkVec);
            Block lastAirBlock = null;
            for (int cpt = 2; cpt < amount && this.isAirBlock((checkLoc = eyeLoc.clone().add(eyeVec.clone().multiply(cpt))).getBlock()) && this.isAirBlock(checkLoc.clone().getBlock()); ++cpt) {
                lastAirBlock = checkLoc.clone().getBlock();
            }
            if (lastAirBlock != null && TeleportOnCursorManager.getInstance().canTp(receiver.getUniqueId())) {
                Location toTeleport = lastAirBlock.getLocation();
                toTeleport.setPitch(receiver.getLocation().getPitch());
                toTeleport.setYaw(receiver.getLocation().getYaw());
                receiver.teleport(toTeleport);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAirBlock(Block block) {
        Material mat = block.getType();
        return SCore.is1v16Plus() && mat.isAir() || !SCore.is1v16Plus() && mat.equals((Object)Material.AIR);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        ArgumentChecker ac2;
        if (args.size() >= 1 && !(ac2 = UnsafeTeleportOnCursor.checkInteger(args.get(0), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("UNSAFE_TELEPORTONCURSOR");
        return names;
    }

    @Override
    public String getTemplate() {
        return "UNSAFE_TELEPORTONCURSOR [maxRange]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

