/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SetItemlore
extends PlayerCommand {
    public SetItemlore() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)-1);
        slot.setSlot(true);
        CommandSetting line = new CommandSetting("line", 1, Integer.class, (Object)1);
        CommandSetting text = new CommandSetting("text", 2, String.class, (Object)"&6New_lore_line");
        text.setAcceptUnderScoreForLongText(true);
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(line);
        settings.add(text);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        int line = (Integer)sCommandToExec.getSettingValue("line");
        String text = (String)sCommandToExec.getSettingValue("text");
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        ItemMeta itemmeta = item.getItemMeta();
        List<String> args = sCommandToExec.getOtherArgs();
        StringBuilder message = new StringBuilder(text);
        message.append(" ");
        for (String s : args) {
            message.append(s).append(" ");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        List list = itemmeta.getLore();
        if (list == null) {
            return;
        }
        if (list.size() < line) {
            return;
        }
        if (line > 0) {
            --line;
        }
        list.set(line, StringConverter.coloredString(message.toString()));
        itemmeta.setLore(list);
        item.setItemMeta(itemmeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_ITEM_LORE");
        names.add("SET_LORE");
        names.add("SETLORE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_ITEM_LORE slot:-1 line:1 text:&6New_lore_line";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

