/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.entity.Player;

public class IfHasPermission
extends PlayerConditionFeature<ListUncoloredStringFeature, IfHasPermission> {
    public IfHasPermission(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifHasPermission);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        Player player = request.getPlayer();
        if (this.hasCondition()) {
            boolean valid = true;
            for (String perm : ((ListUncoloredStringFeature)this.getCondition()).getValue(request.getSp())) {
                if (player.hasPermission(perm)) continue;
                valid = false;
                break;
            }
            if (!valid) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfHasPermission getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListUncoloredStringFeature(this.getParent(), new ArrayList<String>(), FeatureSettingsSCore.ifHasPermission, Optional.empty()));
    }

    @Override
    public boolean hasCondition() {
        return ((ListUncoloredStringFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfHasPermission getNewInstance(FeatureParentInterface parent) {
        return new IfHasPermission(parent);
    }
}

