/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.usedapi.ExcellentClaimsAPI;
import com.ssomar.score.usedapi.FactionsUUIDAPI;
import com.ssomar.score.usedapi.GriefDefenderAPI;
import com.ssomar.score.usedapi.GriefPreventionAPI;
import com.ssomar.score.usedapi.LandsIntegrationAPI;
import com.ssomar.score.usedapi.ProtectionStonesAPI;
import com.ssomar.score.usedapi.ResidenceAPI;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class IfPlayerMustBeOnHisClaim
extends PlayerConditionFeature<BooleanFeature, IfPlayerMustBeOnHisClaim> {
    public IfPlayerMustBeOnHisClaim(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerMustBeOnHisClaim);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (((BooleanFeature)this.getCondition()).getValue(request.getSp()).booleanValue()) {
            FactionsUUIDAPI factionsUUIDAPI;
            LandsIntegrationAPI lands;
            Player player = request.getPlayer();
            if (SCore.hasLands && !(lands = new LandsIntegrationAPI((Plugin)SCore.plugin)).playerIsInHisClaim(player, player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
            if (SCore.hasFactionsUUID && !(factionsUUIDAPI = new FactionsUUIDAPI()).playerIsInHisClaim(player.getUniqueId(), player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
            if (SCore.hasGriefPrevention && !GriefPreventionAPI.playerIsInHisClaim(player, player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
            if (SCore.hasGriefDefender && !GriefDefenderAPI.playerIsInHisClaim(player, player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
            if (SCore.hasResidence && !ResidenceAPI.playerIsInHisClaim(player, player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
            if (SCore.hasProtectionStones && !ProtectionStonesAPI.playerIsInHisClaim(player, player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
            if (SCore.hasExcellentClaims && !ExcellentClaimsAPI.playerIsInHisClaim(player, player.getLocation(), false)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerMustBeOnHisClaim getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.ifPlayerMustBeOnHisClaim));
    }

    @Override
    public boolean hasCondition() {
        return ((BooleanFeature)this.getCondition()).isConfigured();
    }

    @Override
    public IfPlayerMustBeOnHisClaim getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerMustBeOnHisClaim(parent);
    }
}

