/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.entity.Player;

public class IfPlayerOxygen
extends PlayerConditionFeature<NumberConditionFeature, IfPlayerOxygen> {
    public IfPlayerOxygen(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerOxygen);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            int oxygen = player.getRemainingAir();
            if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(Optional.of(player), request.getSp()).get(), oxygen)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerOxygen getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifPlayerOxygen));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfPlayerOxygen getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerOxygen(parent);
    }
}

