/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.world.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.world.WorldConditionFeature;
import com.ssomar.score.features.custom.conditions.world.WorldConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.World;

public class IfWorldTime
extends WorldConditionFeature<NumberConditionFeature, IfWorldTime> {
    public IfWorldTime(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifWorldTime);
    }

    @Override
    public boolean verifCondition(WorldConditionRequest request) {
        World world = request.getWorld();
        if (this.hasCondition() && !StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(request.getPlayerOpt(), request.getSp()).get(), world.getTime())) {
            this.runInvalidCondition(request);
            return false;
        }
        return true;
    }

    @Override
    public IfWorldTime getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this, FeatureSettingsSCore.ifWorldTime));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfWorldTime getNewInstance(FeatureParentInterface parent) {
        return new IfWorldTime(parent);
    }
}

