/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.detailedblocks;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.list.ListDetailedMaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailedBlocks
extends FeatureWithHisOwnEditor<DetailedBlocks, DetailedBlocks, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements Serializable {
    private ListDetailedMaterialFeature blocks;
    private BooleanFeature cancelEventIfNotValid;
    private transient ColoredStringFeature messageIfNotValid;
    private boolean disableCancelEventIfNotValid = false;
    private boolean disableMessageIfNotValid = false;
    private boolean notSaveIfEqualsToDefaultValue;
    private final boolean DEBUG = true;

    public DetailedBlocks(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
        this.notSaveIfEqualsToDefaultValue = false;
    }

    public DetailedBlocks(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, boolean disableCancelEventIfNotValid, boolean disableMessageIfNotValid, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, featureSettings);
        this.reset();
        this.disableCancelEventIfNotValid = disableCancelEventIfNotValid;
        this.disableMessageIfNotValid = disableMessageIfNotValid;
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }

    public DetailedBlocks(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.detailedBlocks);
        this.reset();
        this.notSaveIfEqualsToDefaultValue = false;
    }

    public DetailedBlocks(FeatureParentInterface parent, boolean disableCancelEventIfNotValid, boolean disableMessageIfNotValid) {
        super(parent, FeatureSettingsSCore.detailedBlocks);
        this.reset();
        this.disableCancelEventIfNotValid = disableCancelEventIfNotValid;
        this.disableMessageIfNotValid = disableMessageIfNotValid;
        this.notSaveIfEqualsToDefaultValue = false;
    }

    @Override
    public void reset() {
        this.blocks = new ListDetailedMaterialFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.blocks, true);
        this.cancelEventIfNotValid = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfNotValid);
        this.messageIfNotValid = new ColoredStringFeature(this, Optional.empty(), FeatureSettingsSCore.messageIfNotValid);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.blocks.load(plugin, section, isPremiumLoading));
            if (!this.disableCancelEventIfNotValid) {
                errors.addAll(this.cancelEventIfNotValid.load(plugin, section, isPremiumLoading));
            }
            if (!this.disableMessageIfNotValid) {
                errors.addAll(this.messageIfNotValid.load(plugin, section, isPremiumLoading));
            }
        }
        return errors;
    }

    public boolean isValid(@NotNull Block block, Optional<Player> playerOpt, Event event, StringPlaceholder sp) {
        return this.isValid(block, playerOpt, event, sp, null, Optional.empty());
    }

    public boolean isValid(@NotNull Block block, Optional<Player> playerOpt, Event event, StringPlaceholder sp, @Nullable Material material, @NotNull Optional<String> statesStrOpt) {
        SsomarDev.testMsg("DetailedBlocks 1", true);
        if (this.blocks.getValues().isEmpty() && this.blocks.getBlacklistedValues().isEmpty()) {
            return true;
        }
        SsomarDev.testMsg("DetailedBlocks 2", true);
        if (this.blocks.verifBlock(block, material, statesStrOpt)) {
            SsomarDev.testMsg("DetailedBlocks 3 OK", true);
            return true;
        }
        SsomarDev.testMsg("DetailedBlocks 3 K0", true);
        if (event != null && this.cancelEventIfNotValid.getValue().booleanValue() && event instanceof Cancellable) {
            ((Cancellable)event).setCancelled(true);
        }
        if (playerOpt.isPresent() && this.messageIfNotValid != null && ((Optional)this.messageIfNotValid.getValue()).isPresent()) {
            SendMessage.sendMessageNoPlch(playerOpt.get(), sp.replacePlaceholder((String)((Optional)this.messageIfNotValid.getValue()).get()));
        }
        return false;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfEqualsToDefaultValue && this.blocks.getValues().isEmpty() && this.blocks.getBlacklistedValues().isEmpty()) {
            return;
        }
        ConfigurationSection section = config.createSection(this.getName());
        this.blocks.save(section);
        if (!this.disableCancelEventIfNotValid) {
            this.cancelEventIfNotValid.save(section);
        }
        if (!this.disableMessageIfNotValid) {
            this.messageIfNotValid.save(section);
        }
    }

    @Override
    public DetailedBlocks getValue() {
        return this;
    }

    @Override
    public DetailedBlocks initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = this.blocks.getValues().isEmpty() && !this.blocks.getBlacklistedValues().isEmpty() ? "&7Blocks: &e&lALL BLOCKS" : "&7Detailed Blocks: &a+" + this.blocks.getCurrentValues().size();
        finalDescription[finalDescription.length - 2] = ((Optional)this.messageIfNotValid.getValue()).isPresent() ? "&7Message if NV: &e" + (String)((Optional)this.messageIfNotValid.getValue()).get() : "&7Message if NV: &cNO MESSAGE";
        finalDescription[finalDescription.length - 1] = this.cancelEventIfNotValid.getValue() != false ? "&7Cancel Event if NV: &a&l\u2714" : "&7Cancel Event if NV: &c&l\u2718";
        for (int i = 0; i < finalDescription.length; ++i) {
            String command = finalDescription[i];
            if (command.length() > 40) {
                command = command.substring(0, 39) + "...";
            }
            finalDescription[i] = command;
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DetailedBlocks clone(FeatureParentInterface newParent) {
        DetailedBlocks dropFeatures = new DetailedBlocks(newParent, this.getFeatureSettings());
        dropFeatures.setBlocks(this.blocks.clone(dropFeatures));
        dropFeatures.setCancelEventIfNotValid(this.cancelEventIfNotValid.clone(dropFeatures));
        dropFeatures.setMessageIfNotValid(this.messageIfNotValid.clone(dropFeatures));
        dropFeatures.setDisableMessageIfNotValid(this.disableMessageIfNotValid);
        dropFeatures.setDisableCancelEventIfNotValid(this.disableCancelEventIfNotValid);
        dropFeatures.setNotSaveIfEqualsToDefaultValue(this.notSaveIfEqualsToDefaultValue);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>(Arrays.asList(this.blocks));
        if (!this.disableCancelEventIfNotValid) {
            features.add((ListDetailedMaterialFeature)((Object)this.cancelEventIfNotValid));
        }
        if (!this.disableMessageIfNotValid) {
            features.add(this.messageIfNotValid);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo() + ".(" + this.getName() + ")";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DetailedBlocks) || !feature.getEditorName().equals(this.getEditorName())) continue;
            DetailedBlocks hiders = (DetailedBlocks)feature;
            hiders.setBlocks(this.blocks);
            hiders.setCancelEventIfNotValid(this.cancelEventIfNotValid);
            hiders.setMessageIfNotValid(this.messageIfNotValid);
            hiders.disableMessageIfNotValid = this.disableMessageIfNotValid;
            hiders.disableCancelEventIfNotValid = this.disableCancelEventIfNotValid;
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public ListDetailedMaterialFeature getBlocks() {
        return this.blocks;
    }

    @Generated
    public BooleanFeature getCancelEventIfNotValid() {
        return this.cancelEventIfNotValid;
    }

    @Generated
    public ColoredStringFeature getMessageIfNotValid() {
        return this.messageIfNotValid;
    }

    @Generated
    public boolean isDisableCancelEventIfNotValid() {
        return this.disableCancelEventIfNotValid;
    }

    @Generated
    public boolean isDisableMessageIfNotValid() {
        return this.disableMessageIfNotValid;
    }

    @Generated
    public boolean isNotSaveIfEqualsToDefaultValue() {
        return this.notSaveIfEqualsToDefaultValue;
    }

    @Generated
    public boolean isDEBUG() {
        return this.DEBUG;
    }

    @Generated
    public void setBlocks(ListDetailedMaterialFeature blocks) {
        this.blocks = blocks;
    }

    @Generated
    public void setCancelEventIfNotValid(BooleanFeature cancelEventIfNotValid) {
        this.cancelEventIfNotValid = cancelEventIfNotValid;
    }

    @Generated
    public void setMessageIfNotValid(ColoredStringFeature messageIfNotValid) {
        this.messageIfNotValid = messageIfNotValid;
    }

    @Generated
    public void setDisableCancelEventIfNotValid(boolean disableCancelEventIfNotValid) {
        this.disableCancelEventIfNotValid = disableCancelEventIfNotValid;
    }

    @Generated
    public void setDisableMessageIfNotValid(boolean disableMessageIfNotValid) {
        this.disableMessageIfNotValid = disableMessageIfNotValid;
    }

    @Generated
    public void setNotSaveIfEqualsToDefaultValue(boolean notSaveIfEqualsToDefaultValue) {
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }
}

