/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.detailedeffects;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.list.ListDetailedEffectFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class DetailedEffects
extends FeatureWithHisOwnEditor<DetailedEffects, DetailedEffects, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements Serializable {
    private ListDetailedEffectFeature effects;
    private BooleanFeature cancelEventIfNotValid;
    private transient ColoredStringFeature messageIfNotValid;

    public DetailedEffects(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    public DetailedEffects(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.detailedEffects);
        this.reset();
    }

    @Override
    public void reset() {
        this.effects = new ListDetailedEffectFeature(this, new ArrayList<String>(), FeatureSettingsSCore.effects, false);
        this.cancelEventIfNotValid = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfNotValid);
        this.messageIfNotValid = new ColoredStringFeature(this, Optional.empty(), FeatureSettingsSCore.messageIfNotValid);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.effects.load(plugin, section, isPremiumLoading));
            errors.addAll(this.cancelEventIfNotValid.load(plugin, section, isPremiumLoading));
            errors.addAll(this.messageIfNotValid.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    public boolean isValid(@NotNull PotionEffectType type, Optional<Player> playerOpt, Event event, StringPlaceholder sp) {
        if (this.effects.getValues().isEmpty() && this.effects.getBlackListValues().isEmpty()) {
            return true;
        }
        if (this.effects.isValidEffect(type)) {
            return true;
        }
        if (event != null && this.cancelEventIfNotValid.getValue().booleanValue() && event instanceof Cancellable) {
            ((Cancellable)event).setCancelled(true);
        }
        if (playerOpt.isPresent() && this.messageIfNotValid != null && ((Optional)this.messageIfNotValid.getValue()).isPresent()) {
            SendMessage.sendMessageNoPlch(playerOpt.get(), sp.replacePlaceholder((String)((Optional)this.messageIfNotValid.getValue()).get()));
        }
        return false;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.effects.save(section);
        this.cancelEventIfNotValid.save(section);
        this.messageIfNotValid.save(section);
    }

    @Override
    public DetailedEffects getValue() {
        return this;
    }

    @Override
    public DetailedEffects initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = this.effects.getValues().isEmpty() && !this.effects.getBlackListValues().isEmpty() ? "&7Blocks: &e&lALL EFFECTS" : "&7Detailed Effects: &a+" + this.effects.getCurrentValues().size();
        finalDescription[finalDescription.length - 2] = ((Optional)this.messageIfNotValid.getValue()).isPresent() ? "&7Message if NV: &e" + (String)((Optional)this.messageIfNotValid.getValue()).get() : "&7Message if NV: &cNO MESSAGE";
        finalDescription[finalDescription.length - 1] = this.cancelEventIfNotValid.getValue() != false ? "&7Cancel Event if NV: &a&l\u2714" : "&7Cancel Event if NV: &c&l\u2718";
        for (int i = 0; i < finalDescription.length; ++i) {
            String command = finalDescription[i];
            if (command.length() > 40) {
                command = command.substring(0, 39) + "...";
            }
            finalDescription[i] = command;
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DetailedEffects clone(FeatureParentInterface newParent) {
        DetailedEffects dropFeatures = new DetailedEffects(newParent, this.getFeatureSettings());
        dropFeatures.setEffects(this.effects.clone(dropFeatures));
        dropFeatures.setCancelEventIfNotValid(this.cancelEventIfNotValid.clone(dropFeatures));
        dropFeatures.setMessageIfNotValid(this.messageIfNotValid.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.effects, this.messageIfNotValid, this.cancelEventIfNotValid));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo() + ".(" + this.getName() + ")";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DetailedEffects) || !feature.getEditorName().equals(this.getEditorName())) continue;
            DetailedEffects hiders = (DetailedEffects)feature;
            hiders.setEffects(this.effects);
            hiders.setCancelEventIfNotValid(this.cancelEventIfNotValid);
            hiders.setMessageIfNotValid(this.messageIfNotValid);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public ListDetailedEffectFeature getEffects() {
        return this.effects;
    }

    @Generated
    public BooleanFeature getCancelEventIfNotValid() {
        return this.cancelEventIfNotValid;
    }

    @Generated
    public ColoredStringFeature getMessageIfNotValid() {
        return this.messageIfNotValid;
    }

    @Generated
    public void setEffects(ListDetailedEffectFeature effects) {
        this.effects = effects;
    }

    @Generated
    public void setCancelEventIfNotValid(BooleanFeature cancelEventIfNotValid) {
        this.cancelEventIfNotValid = cancelEventIfNotValid;
    }

    @Generated
    public void setMessageIfNotValid(ColoredStringFeature messageIfNotValid) {
        this.messageIfNotValid = messageIfNotValid;
    }
}

