/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.durabilityFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DurabilityFeatures
extends FeatureWithHisOwnEditor<DurabilityFeatures, DurabilityFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature maxDurability;
    private IntegerFeature durability;
    private BooleanFeature isDurabilityBasedOnUsage;

    public DurabilityFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.durability_features);
        this.reset();
    }

    @Override
    public void reset() {
        this.maxDurability = new IntegerFeature(this, Optional.empty(), FeatureSettingsSCore.maxDurability);
        this.durability = new IntegerFeature(this, Optional.empty(), FeatureSettingsSCore.durability);
        this.isDurabilityBasedOnUsage = new BooleanFeature(this, false, FeatureSettingsSCore.isDurabilityBasedOnUsage);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (SCore.is1v20v5Plus()) {
            errors.addAll(this.isDurabilityBasedOnUsage.load(plugin, config, isPremiumLoading));
            errors.addAll(this.maxDurability.load(plugin, config, isPremiumLoading));
        }
        errors.addAll(this.durability.load(plugin, config, isPremiumLoading));
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (SCore.is1v20v5Plus()) {
            this.maxDurability.save(config);
            this.isDurabilityBasedOnUsage.save(config);
        }
        this.durability.save(config);
    }

    @Override
    public DurabilityFeatures getValue() {
        return this;
    }

    @Override
    public DurabilityFeatures initItemParentEditor(GUI gui, int slot) {
        int amount = 2;
        if (SCore.is1v20v5Plus()) {
            amount = 4;
        }
        String[] finalDescription = new String[this.getEditorDescription().length + amount];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - amount] = GUI.CLICK_HERE_TO_CHANGE;
        --amount;
        if (SCore.is1v20v5Plus()) {
            finalDescription[finalDescription.length - amount] = this.isDurabilityBasedOnUsage.getValue() != false ? "&7isDurabilityBasedOnUsage: &a&l\u2714" : "&7isDurabilityBasedOnUsage: &c&l\u2718";
            finalDescription[finalDescription.length - --amount] = ((Optional)this.maxDurability.getValue()).isPresent() ? "&7Max durability: &e" + ((Optional)this.maxDurability.getValue()).get() : "&7Max durability: &cNot set";
            --amount;
        }
        finalDescription[finalDescription.length - amount] = ((Optional)this.durability.getValue()).isPresent() ? "&7Durability: &e" + ((Optional)this.durability.getValue()).get() : "&7Durability: &cNot set";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DurabilityFeatures clone(FeatureParentInterface newParent) {
        DurabilityFeatures dropFeatures = new DurabilityFeatures(newParent);
        dropFeatures.maxDurability = this.maxDurability.clone(dropFeatures);
        dropFeatures.durability = this.durability.clone(dropFeatures);
        dropFeatures.isDurabilityBasedOnUsage = this.isDurabilityBasedOnUsage.clone(dropFeatures);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        if (SCore.is1v20v5Plus()) {
            features.add(this.isDurabilityBasedOnUsage);
            features.add(this.maxDurability);
        }
        features.add(this.durability);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DurabilityFeatures)) continue;
            DurabilityFeatures hiders = (DurabilityFeatures)feature;
            hiders.setMaxDurability(this.maxDurability);
            hiders.setDurability(this.durability);
            hiders.setIsDurabilityBasedOnUsage(this.isDurabilityBasedOnUsage);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getMaxDurability() {
        return this.maxDurability;
    }

    @Generated
    public IntegerFeature getDurability() {
        return this.durability;
    }

    @Generated
    public BooleanFeature getIsDurabilityBasedOnUsage() {
        return this.isDurabilityBasedOnUsage;
    }

    @Generated
    public void setMaxDurability(IntegerFeature maxDurability) {
        this.maxDurability = maxDurability;
    }

    @Generated
    public void setDurability(IntegerFeature durability) {
        this.durability = durability;
    }

    @Generated
    public void setIsDurabilityBasedOnUsage(BooleanFeature isDurabilityBasedOnUsage) {
        this.isDurabilityBasedOnUsage = isDurabilityBasedOnUsage;
    }
}

