/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.patterns.subgroup;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.patterns.subgroup.PatternFeatureEditor;
import com.ssomar.score.features.custom.patterns.subgroup.PatternFeatureEditorManager;
import com.ssomar.score.features.custom.patterns.subpattern.SubPatternFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.block.banner.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PatternFeature
extends FeatureWithHisOwnEditor<PatternFeature, PatternFeature, PatternFeatureEditor, PatternFeatureEditorManager>
implements FeaturesGroup<SubPatternFeature> {
    private Map<String, SubPatternFeature> subPattern;
    private String id;

    public PatternFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.subPatterns);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.subPattern = new HashMap<String, SubPatternFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.id);
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                SubPatternFeature attribute = new SubPatternFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.subPattern.put(attributeID, attribute);
            }
        }
        return error;
    }

    public void load(SPlugin plugin, Pattern pattern, boolean isPremiumLoading) {
        Map map = pattern.serialize();
        int i = 0;
        for (String key : map.keySet()) {
            SubPatternFeature subPattern = new SubPatternFeature((FeatureParentInterface)this, "subPattern" + i);
            subPattern.getString().setValue(Optional.of(key));
            subPattern.getObject().setValue(map.get(key));
            this.subPattern.put("subPattern" + i, subPattern);
            ++i;
        }
    }

    public Pattern getPattern() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SubPatternFeature sP : this.subPattern.values()) {
            map.put((String)((Optional)sP.getString().getValue()).get(), sP.getObject().getValue());
        }
        return new Pattern(map);
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributesSection = config.createSection(this.id);
        for (String enchantmentID : this.subPattern.keySet()) {
            this.subPattern.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public PatternFeature getValue() {
        return this;
    }

    @Override
    public PatternFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oSub Pattern(s) added: &e" + this.subPattern.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public SubPatternFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (SubPatternFeature x : this.subPattern.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public PatternFeature clone(FeatureParentInterface newParent) {
        PatternFeature eF = new PatternFeature(newParent, this.id);
        HashMap<String, SubPatternFeature> newSubPattern = new HashMap<String, SubPatternFeature>();
        for (String key : this.subPattern.keySet()) {
            newSubPattern.put(key, this.subPattern.get(key).clone(eF));
        }
        eF.setSubPattern(newSubPattern);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.subPattern.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof PatternFeature)) continue;
            PatternFeature eF = (PatternFeature)feature;
            eF.setSubPattern(this.getSubPattern());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        PatternFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "subPattern";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.subPattern.containsKey(id)) continue;
            SubPatternFeature eF = new SubPatternFeature((FeatureParentInterface)this, id);
            this.subPattern.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, SubPatternFeature feature) {
        this.subPattern.remove(feature.getId());
    }

    @Generated
    public Map<String, SubPatternFeature> getSubPattern() {
        return this.subPattern;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setSubPattern(Map<String, SubPatternFeature> subPattern) {
        this.subPattern = subPattern;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

