/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.editor;

import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.NewInteractionClickedGUIManager;
import com.ssomar.score.editor.SaveSessionPathManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireClicksOrOneMessageInEditor;
import com.ssomar.score.features.FeatureRequireMultipleMessageInEditor;
import com.ssomar.score.features.FeatureRequireOneMessageInEditor;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.editor.FeatureEditorInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;

public abstract class FeatureEditorManagerAbstract<T extends FeatureEditorInterface<Y>, Y extends FeatureParentInterface>
extends NewGUIManager<T> {
    public void startEditing(Player editor, Y feature) {
        this.cache.put(editor, this.buildEditor(feature));
        ((FeatureEditorInterface)this.cache.get(editor)).openGUISync(editor);
        SaveSessionPathManager.getInstance().addPlayerSessionPath(editor, (GUI)this.cache.get(editor));
    }

    public abstract T buildEditor(Y var1);

    @Override
    public boolean allClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName)) continue;
            if (feature instanceof FeatureRequireOnlyClicksInEditor && !(feature instanceof FeatureRequireOneMessageInEditor) || feature instanceof FeatureRequireClicksOrOneMessageInEditor) {
                ((FeatureRequireOnlyClicksInEditor)((Object)feature)).clickParentEditor(i.player, this);
            } else if (feature instanceof FeatureRequireOneMessageInEditor && !(feature instanceof FeatureRequireOnlyClicksInEditor)) {
                ((FeatureRequireOneMessageInEditor)((Object)feature)).askInEditor(i.player, this);
            } else if (feature instanceof FeatureRequireMultipleMessageInEditor) {
                ((FeatureRequireMultipleMessageInEditor)((Object)feature)).askInEditorFirstTime(i.player, this);
            } else if (feature instanceof FeatureRequireSubTextEditorInEditor) {
                FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
                this.requestWriting.put(i.player, feature.getEditorName());
                this.currentWriting.put(i.player, featureRequireSubTextEditorInEditor.getCurrentValues());
                this.suggestions.put(i.player, featureRequireSubTextEditorInEditor.getSuggestions());
                this.moreInfo = featureRequireSubTextEditorInEditor.getMoreInfo();
                this.enableTextEditor(i.player);
                i.player.closeInventory();
                ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
                this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
            } else if (feature instanceof FeatureParentInterface) {
                ((FeatureEditorInterface)i.gui).getParent().reload();
                ((FeatureEditorInterface)i.gui).getParent().save();
                FeatureParentInterface parent = (FeatureParentInterface)feature;
                parent.openEditor(i.player);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            feature.reset();
        }
        ((FeatureEditorInterface)i.gui).load();
    }

    @Override
    public void newObject(NewInteractionClickedGUIManager<T> i) {
        if (((FeatureEditorInterface)i.gui).getParent() instanceof FeaturesGroup) {
            ((FeaturesGroup)((FeatureEditorInterface)i.gui).getParent()).createNewFeature(i.player);
            ((FeatureEditorInterface)i.gui).update();
        }
    }

    @Override
    public void back(NewInteractionClickedGUIManager<T> interact) {
        Player player = interact.player;
        GUI gui = SaveSessionPathManager.getInstance().getLastBeforePlayerSessionPath(player);
        if (gui != null) {
            gui.update();
            gui.openGUISync(player);
        } else {
            Object parent = ((FeatureEditorInterface)interact.gui).getParent();
            parent.openBackEditor(interact.player);
        }
        SaveSessionPathManager.getInstance().removeLastPlayerSessionPath(interact.player);
    }

    @Override
    public boolean noShiftclicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).noShiftclicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).noShiftLeftclicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean noShiftRightclicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).noShiftRightclicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean shiftClicked(NewInteractionClickedGUIManager<T> i) {
        if (((FeatureEditorInterface)i.gui).getParent() instanceof FeaturesGroup) {
            Object feature = ((FeaturesGroup)((FeatureEditorInterface)i.gui).getParent()).getTheChildFeatureClickedParentEditor(i.decoloredName);
            if (feature == null) {
                return false;
            }
            ((FeaturesGroup)((FeatureEditorInterface)i.gui).getParent()).deleteFeature(i.player, feature);
            this.save(i);
            ((FeatureEditorInterface)i.gui).update();
            return true;
        }
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).shiftClicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean shiftLeftClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).shiftLeftClicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean shiftRightClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).shiftRightClicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean leftClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).leftClicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean rightClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).rightClicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean middleClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName)) continue;
            if (feature instanceof FeatureRequireOneMessageInEditor) {
                ((FeatureRequireOneMessageInEditor)((Object)feature)).askInEditor(i.player, this);
                return true;
            }
            if (!(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).middleClicked(i.player, this);
        }
        return false;
    }

    @Override
    public boolean doubleClicked(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!feature.isTheFeatureClickedParentEditor(i.decoloredName) || !(feature instanceof FeatureRequireOnlyClicksInEditor)) continue;
            return ((FeatureRequireOnlyClicksInEditor)((Object)feature)).doubleClicked(i.player, this);
        }
        return false;
    }

    @Override
    public void nextPage(NewInteractionClickedGUIManager<T> interact) {
    }

    @Override
    public void previousPage(NewInteractionClickedGUIManager<T> interact) {
    }

    @Override
    public void receiveMessageDeleteline(NewInteractionClickedGUIManager<T> i) {
        super.receiveMessageDeleteline(i);
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!((String)this.requestWriting.get(i.player)).equals(feature.getEditorName()) || !(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
            this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
        }
    }

    @Override
    public void receiveMessageUpLine(NewInteractionClickedGUIManager<T> i) {
        super.receiveMessageUpLine(i);
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!((String)this.requestWriting.get(i.player)).equals(feature.getEditorName()) || !(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
            this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
        }
    }

    @Override
    public void receiveMessageDownLine(NewInteractionClickedGUIManager<T> i) {
        super.receiveMessageDownLine(i);
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!((String)this.requestWriting.get(i.player)).equals(feature.getEditorName()) || !(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
            this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
        }
    }

    @Override
    public void receiveMessageEditLine(NewInteractionClickedGUIManager<T> i) {
        super.receiveMessageEditLine(i);
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!((String)this.requestWriting.get(i.player)).equals(feature.getEditorName()) || !(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
            this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
        }
    }

    @Override
    public void receiveMessagePreviousPage(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!((String)this.requestWriting.get(i.player)).equals(feature.getEditorName()) || !(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            if ((Integer)this.suggestionPage.get(i.player) != 0) {
                this.suggestionPage.put(i.player, (Integer)this.suggestionPage.get(i.player) - 1);
            }
            ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
            this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
        }
    }

    @Override
    public void receiveMessageNextPage(NewInteractionClickedGUIManager<T> i) {
        for (FeatureInterface feature : ((FeatureEditorInterface)i.gui).getParent().getFeatures()) {
            if (!((String)this.requestWriting.get(i.player)).equals(feature.getEditorName()) || !(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor featureRequireSubTextEditorInEditor = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            this.suggestionPage.put(i.player, (Integer)this.suggestionPage.get(i.player) + 1);
            ((FeatureRequireSubTextEditorInEditor)((Object)feature)).sendBeforeTextEditor(i.player, this);
            this.sendEditor(i.player, featureRequireSubTextEditorInEditor.getTips());
        }
    }

    @Override
    public void receiveMessageFinish(NewInteractionClickedGUIManager<T> interact) {
        for (FeatureInterface feature : ((FeatureEditorInterface)interact.gui).getParent().getFeatures()) {
            if (feature instanceof FeatureRequireMultipleMessageInEditor) {
                if (!feature.getEditorName().equals(this.requestWriting.get(interact.player))) continue;
                ((FeatureRequireMultipleMessageInEditor)((Object)feature)).finishEditInEditor(interact.player, this, null);
                ((FeatureEditorInterface)interact.gui).openGUISync(interact.player);
                continue;
            }
            if (!(feature instanceof FeatureRequireSubTextEditorInEditor) || !feature.getEditorName().equals(this.requestWriting.get(interact.player))) continue;
            FeatureRequireSubTextEditorInEditor f = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            f.finishEditInSubEditor(interact.player, this);
            this.currentWriting.remove(interact.player);
            this.requestWriting.remove(interact.player);
            this.disableTextEditor(interact.player);
            ((FeatureEditorInterface)interact.gui).openGUISync(interact.player);
        }
    }

    @Override
    public void receiveMessageNoValue(NewInteractionClickedGUIManager<T> interact) {
        for (FeatureInterface feature : ((FeatureEditorInterface)interact.gui).getParent().getFeatures()) {
            if (!feature.getEditorName().equals(this.requestWriting.get(interact.player)) || !(feature instanceof FeatureRequireOneMessageInEditor)) continue;
            ((FeatureRequireOneMessageInEditor)((Object)feature)).finishEditInEditorNoValue(interact.player, this);
            ((FeatureEditorInterface)interact.gui).openGUISync(interact.player);
        }
    }

    @Override
    public void receiveMessageValue(final NewInteractionClickedGUIManager<T> interact) {
        for (final FeatureInterface feature : ((FeatureEditorInterface)interact.gui).getParent().getFeatures()) {
            Runnable runnable;
            FeatureEditorManagerAbstract newGUIManager;
            Optional<String> potentialError;
            if (!feature.getEditorName().equals(this.requestWriting.get(interact.player))) continue;
            if (feature instanceof FeatureRequireOneMessageInEditor) {
                potentialError = ((FeatureRequireOneMessageInEditor)((Object)feature)).verifyMessageReceived(interact.message);
                if (potentialError.isPresent()) {
                    interact.player.sendMessage(potentialError.get());
                    newGUIManager = this;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            ((FeatureRequireOneMessageInEditor)((Object)feature)).askInEditor(interact.player, newGUIManager);
                        }
                    };
                    SCore.schedulerHook.runTask(runnable, 0L);
                    continue;
                }
                ((FeatureRequireOneMessageInEditor)((Object)feature)).finishEditInEditor(interact.player, this, interact.message);
                ((FeatureEditorInterface)interact.gui).openGUISync(interact.player);
                continue;
            }
            if (feature instanceof FeatureRequireMultipleMessageInEditor) {
                potentialError = ((FeatureRequireMultipleMessageInEditor)((Object)feature)).verifyMessageReceived(interact.message);
                if (potentialError.isPresent()) {
                    interact.player.sendMessage(potentialError.get());
                    newGUIManager = this;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            ((FeatureRequireOneMessageInEditor)((Object)feature)).askInEditor(interact.player, newGUIManager);
                        }
                    };
                    SCore.schedulerHook.runTask(runnable, 0L);
                    continue;
                }
                ((FeatureRequireMultipleMessageInEditor)((Object)feature)).addMessageValue(interact.player, this, interact.message);
                continue;
            }
            if (!(feature instanceof FeatureRequireSubTextEditorInEditor)) continue;
            FeatureRequireSubTextEditorInEditor f = (FeatureRequireSubTextEditorInEditor)((Object)feature);
            Optional<String> pErrors = f.verifyMessageReceived(interact.message);
            if (pErrors.isPresent()) {
                interact.player.sendMessage(StringConverter.coloredString(pErrors.get()));
                return;
            }
            ((List)this.currentWriting.get(interact.player)).add(interact.message);
            f.sendBeforeTextEditor(interact.player, this);
            this.sendEditor(interact.player, f.getTips());
        }
    }

    @Override
    public void save(NewInteractionClickedGUIManager<T> interact) {
        Object parent = ((FeatureEditorInterface)interact.gui).getParent();
        parent.save();
        parent.reload();
        while (parent instanceof FeatureInterface && ((FeatureAbstract)parent).getParent() != parent) {
            parent = ((FeatureAbstract)parent).getParent();
            parent.reload();
        }
    }
}

