/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class OperationFeature
extends FeatureAbstract<Optional<AttributeModifier.Operation>, OperationFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<AttributeModifier.Operation> value;
    private Optional<AttributeModifier.Operation> defaultValue;

    public OperationFeature(FeatureParentInterface parent, Optional<AttributeModifier.Operation> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)colorStr.toUpperCase());
            this.value = Optional.ofNullable(operation);
            FeatureReturnCheckPremium<AttributeModifier.Operation> checkPremium = this.checkPremium("Operation", operation, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the AttributeModifier.Operation value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> AttributeModifier.Operation available: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/attribute/AttributeModifier.Operation.html");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(operation -> config.set(this.getName(), (Object)operation.name()));
    }

    @Override
    public Optional<AttributeModifier.Operation> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public OperationFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        AttributeModifier.Operation finalValue = ((Optional)value).orElse(AttributeModifier.Operation.ADD_NUMBER);
        this.updateOperation(finalValue, gui);
    }

    @Override
    public OperationFeature clone(FeatureParentInterface newParent) {
        OperationFeature clone = new OperationFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        AttributeModifier.Operation operation = this.getOperation((GUI)manager.getCache().get(editor));
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        this.updateOperation(operation, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        AttributeModifier.Operation operation = this.getOperation((GUI)manager.getCache().get(editor));
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        this.updateOperation(operation, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateOperation(this.nextOperation(this.getOperation((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateOperation(this.prevOperation(this.getOperation((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public AttributeModifier.Operation nextOperation(AttributeModifier.Operation operation) {
        boolean next = false;
        for (AttributeModifier.Operation check : this.getSortOperations()) {
            if (check.equals((Object)operation)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortOperations().get(0);
    }

    public AttributeModifier.Operation prevOperation(AttributeModifier.Operation operation) {
        int i = -1;
        int cpt = 0;
        for (AttributeModifier.Operation check : this.getSortOperations()) {
            if (check.equals((Object)operation)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortOperations().get(this.getSortOperations().size() - 1);
        }
        return this.getSortOperations().get(cpt - 1);
    }

    public void updateOperation(AttributeModifier.Operation operation, GUI gui) {
        this.value = Optional.of(operation);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortOperations().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (AttributeModifier.Operation check : this.getSortOperations()) {
            if (operation.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + operation.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (AttributeModifier.Operation check : this.getSortOperations()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public AttributeModifier.Operation getOperation(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return AttributeModifier.Operation.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<AttributeModifier.Operation> getSortOperations() {
        TreeMap<String, AttributeModifier.Operation> map = new TreeMap<String, AttributeModifier.Operation>();
        for (AttributeModifier.Operation l : AttributeModifier.Operation.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<AttributeModifier.Operation>(map.values());
    }

    @Generated
    public Optional<AttributeModifier.Operation> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<AttributeModifier.Operation> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<AttributeModifier.Operation> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

