/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class ListEffectAndLevelFeature
extends FeatureAbstract<Map<PotionEffectType, Integer>, ListEffectAndLevelFeature>
implements FeatureRequireSubTextEditorInEditor {
    private Map<PotionEffectType, Integer> value;
    private Map<PotionEffectType, Integer> defaultValue;
    private boolean notSaveIfEqualsToDefaultValue;

    public ListEffectAndLevelFeature(FeatureParentInterface parent, Map<PotionEffectType, Integer> defaultValue, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.value = this.transformEffects(config.getStringList(this.getName()), errors);
        return errors;
    }

    public Map<PotionEffectType, Integer> transformEffects(List<String> enchantsConfig, List<String> errorList) {
        HashMap<PotionEffectType, Integer> result = new HashMap<PotionEffectType, Integer>();
        for (String s : enchantsConfig) {
            boolean error = false;
            if (!s.contains(":")) continue;
            String[] decomp = s.split(":");
            try {
                PotionEffectType effect = PotionEffectType.getByName((String)decomp[0]);
                if (effect == null) {
                    error = true;
                } else {
                    int level = Integer.parseInt(decomp[1]);
                    result.put(effect, level);
                }
            }
            catch (Exception e) {
                error = true;
            }
            if (!error) continue;
            errorList.add("&cERROR, Couldn't load the Effect with level value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> correct form > EFFECT:LEVEL  example> SPEED:1 !");
        }
        return result;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfEqualsToDefaultValue && this.value.isEmpty()) {
            return;
        }
        config.set(this.getName(), this.getCurrentValues());
    }

    public Map<PotionEffectType, Integer> getValues() {
        return this.value;
    }

    @Override
    public ListEffectAndLevelFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        gui.updateConditionList(this.getEditorName(), this.getCurrentValues(), "&cEMPTY");
    }

    @Override
    public ListEffectAndLevelFeature clone(FeatureParentInterface newParent) {
        ListEffectAndLevelFeature clone = new ListEffectAndLevelFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isNotSaveIfEqualsToDefaultValue());
        clone.setValue(this.getValues());
        return clone;
    }

    @Override
    public void reset() {
        this.value = new HashMap<PotionEffectType, Integer>(this.defaultValue);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        String s = StringConverter.decoloredString(message);
        boolean error = false;
        if (s.contains(":")) {
            String[] decomp = s.split(":");
            try {
                PotionEffectType enchant = PotionEffectType.getByName((String)decomp[0]);
                if (enchant == null) {
                    error = true;
                } else {
                    Integer.parseInt(decomp[1]);
                }
            }
            catch (Exception e) {
                error = true;
            }
            if (error) {
                return Optional.of("&4&l[ERROR] &cThe message you entered &8(&7" + s + "&8)&c is not an effect with level &6>> correct form > EFFECT:LEVEL  example> SPEED:1 !");
            }
        }
        return Optional.empty();
    }

    @Override
    public List<String> getCurrentValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<PotionEffectType, Integer> entry : this.value.entrySet()) {
            result.add(entry.getKey().getName().toUpperCase() + ":" + entry.getValue());
        }
        return result;
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (PotionEffectType effect : PotionEffectType.values()) {
            if (effect == null) continue;
            map.put(effect.getName() + "", new Suggestion(effect.getName() + ":1", "&6[&e" + effect.getName() + "&6]", "&7Add &e" + effect.getName()));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "&8Example &7&oSPEED:1";
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        List<String> preResult = manager.currentWriting.get(editor);
        for (int i = 0; i < preResult.size(); ++i) {
            preResult.set(i, StringConverter.decoloredString(preResult.get(i)));
        }
        this.value = this.transformEffects(preResult, new ArrayList<String>());
        manager.requestWriting.remove(editor);
        manager.activeTextEditor.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Override
    @Generated
    public Map<PotionEffectType, Integer> getValue() {
        return this.value;
    }

    @Generated
    public Map<PotionEffectType, Integer> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isNotSaveIfEqualsToDefaultValue() {
        return this.notSaveIfEqualsToDefaultValue;
    }

    @Generated
    public void setValue(Map<PotionEffectType, Integer> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Map<PotionEffectType, Integer> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setNotSaveIfEqualsToDefaultValue(boolean notSaveIfEqualsToDefaultValue) {
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }
}

