/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.hardness.hardness.loader;

import com.ssomar.score.SCore;
import com.ssomar.score.hardness.hardness.Hardness;
import com.ssomar.score.hardness.hardness.loader.ConfigConverter;
import com.ssomar.score.hardness.hardness.manager.HardnessesManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class HardnessLoader
extends SObjectWithFileLoader<Hardness> {
    private static HardnessLoader instance;
    private static final String DEFAULT = "Default";

    public HardnessLoader() {
        super(SCore.plugin, "/com/ssomar/score/configs/hardnesses/", HardnessesManager.getInstance(), 1000);
    }

    @Override
    public void load() {
        HardnessesManager.getInstance().setDefaultObjects(new ArrayList());
        this.loadDefaultPremiumObjects();
        HardnessesManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File itemsDirectory = new File(SCore.plugin.getDataFolder() + "/hardnesses");
        if (itemsDirectory.exists()) {
            this.loadObjectsInFolder(itemsDirectory, true);
        } else {
            this.createDefaultObjectsFile(true);
            this.load();
        }
    }

    public Map<String, List<String>> getNotEditableProjectilesName() {
        HashMap<String, List<String>> defaultBlocks = new HashMap<String, List<String>>();
        ArrayList defaultProj = new ArrayList();
        defaultBlocks.put(DEFAULT, defaultProj);
        return defaultBlocks;
    }

    @Override
    public void configVersionsConverter(File file) {
        ConfigConverter.update(file);
    }

    @Override
    public Optional<Hardness> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        Hardness item = new Hardness(id, path);
        ArrayList<String> errors = new ArrayList<String>(item.load(SCore.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                SCore.plugin.getServer().getLogger().severe(s);
            }
        }
        return Optional.ofNullable(item);
    }

    public static HardnessLoader getInstance() {
        if (instance == null) {
            instance = new HardnessLoader();
        }
        return instance;
    }
}

