/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.custom;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.pack.custom.PackSettings;
import com.ssomar.score.pack.http.HttpByteBuf;
import com.ssomar.score.pack.http.HttpInjector;
import com.ssomar.score.pack.http.HttpRequest;
import com.ssomar.score.utils.logging.Utils;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.file.Files;

public class PackHttpInjector
extends HttpInjector {
    private PackSettings packSettings;

    public PackHttpInjector(PackSettings packSettings) {
        this.packSettings = packSettings;
    }

    @Override
    public HttpByteBuf intercept(ChannelHandlerContext ctx, HttpRequest request) {
        String requestURI = request.getRequestURI();
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("REQUEST URI : " + requestURI);
        }
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("FILE NAME : " + this.packSettings.getFileName());
        }
        if (GeneralConfig.getInstance().isSelfHostPackDebug()) {
            Utils.sendConsoleMsg("FILE PATH : " + this.packSettings.getFile().getAbsolutePath());
        }
        if (requestURI.equals("/score/" + this.packSettings.getFileName())) {
            try {
                byte[] bytes = Files.readAllBytes(this.packSettings.getFile().toPath());
                HttpByteBuf buf = HttpByteBuf.httpBuf(ctx);
                buf.writeStatusLine("1.1", 200, "OK");
                buf.writeHeader("Content-Length", String.valueOf(bytes.length));
                buf.writeHeader("Content-Type", "application/zip");
                buf.writeHeader("Connection", "close");
                buf.writeBytes(bytes);
                return buf;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

