/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;

public class HttpByteBuf {
    private final ByteBuf inner;

    public HttpByteBuf(ByteBuf inner) {
        this.inner = inner;
    }

    public void writeStatusLine(String protocolVersion, int statusCode, String statusMessage) {
        this.inner.writeCharSequence((CharSequence)("HTTP/" + protocolVersion + " " + statusCode + " " + statusMessage + "\r\n"), StandardCharsets.US_ASCII);
    }

    public void writeHeader(String header, String value) {
        this.inner.writeCharSequence((CharSequence)(header + ": " + value + "\r\n"), StandardCharsets.US_ASCII);
    }

    public void writeText(String text) {
        this.inner.writeCharSequence((CharSequence)("\r\n" + text), StandardCharsets.US_ASCII);
    }

    public void writeBytes(byte[] bytes) {
        this.inner.writeCharSequence((CharSequence)"\r\n", StandardCharsets.US_ASCII);
        this.inner.writeBytes(bytes);
    }

    public ByteBuf inner() {
        return this.inner;
    }

    public static HttpByteBuf httpBuf(ChannelHandlerContext ctx) {
        return new HttpByteBuf(ctx.alloc().buffer());
    }
}

