/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.scheduler;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.scheduler.DateGenerator;
import com.ssomar.score.scheduler.ScheduleFeaturesEditor;
import com.ssomar.score.scheduler.ScheduleFeaturesEditorManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ScheduleFeatures
extends FeatureWithHisOwnEditor<ScheduleFeatures, ScheduleFeatures, ScheduleFeaturesEditor, ScheduleFeaturesEditorManager> {
    private UncoloredStringFeature startDateFeature;
    private UncoloredStringFeature endDateFeature;
    private ListUncoloredStringFeature when;

    public ScheduleFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.scheduleFeatures);
        this.reset();
    }

    public Date getStartDate() {
        try {
            return StringConverter.stringToDate((String)((Optional)this.startDateFeature.getValue()).get());
        }
        catch (Exception e) {
            e.printStackTrace();
            return StringConverter.stringToDate("1700-01-01 00:00:00");
        }
    }

    public Date getEndDate() {
        try {
            return StringConverter.stringToDate((String)((Optional)this.endDateFeature.getValue()).get());
        }
        catch (Exception e) {
            e.printStackTrace();
            return StringConverter.stringToDate("3000-01-01 00:00:00");
        }
    }

    public List<Long> getNextTimestamp(long calculationTime) {
        return DateGenerator.generateNextValidTimestamps(new Date(), this.when.getValues(), calculationTime, this.getStartDate(), this.getEndDate());
    }

    @Override
    public void reset() {
        this.startDateFeature = new UncoloredStringFeature(this, Optional.of("1700-01-01 00:00:00"), FeatureSettingsSCore.startDate, false);
        this.endDateFeature = new UncoloredStringFeature(this, Optional.of("3000-01-01 00:00:00"), FeatureSettingsSCore.endDate, false);
        this.when = new ListUncoloredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.when, Optional.empty());
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            error.addAll(this.startDateFeature.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
            error.addAll(this.endDateFeature.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
            error.addAll(this.when.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.startDateFeature.save(section);
        this.endDateFeature.save(section);
        this.when.save(section);
    }

    @Override
    public ScheduleFeatures getValue() {
        return this;
    }

    @Override
    public ScheduleFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = "\u00a76Start Date: \u00a7e" + (String)((Optional)this.startDateFeature.getValue()).get();
        finalDescription[finalDescription.length - 2] = "\u00a76End Date: \u00a7e" + (String)((Optional)this.endDateFeature.getValue()).get();
        finalDescription[finalDescription.length - 1] = "\u00a76When: \u00a7e" + this.when.getValues().toString();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ScheduleFeatures clone(FeatureParentInterface newParent) {
        ScheduleFeatures dropFeatures = new ScheduleFeatures(newParent);
        dropFeatures.setStartDateFeature(this.startDateFeature.clone(dropFeatures));
        dropFeatures.setEndDateFeature(this.endDateFeature.clone(dropFeatures));
        dropFeatures.setWhen(this.when.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.startDateFeature);
        features.add(this.endDateFeature);
        features.add(this.when);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ScheduleFeatures)) continue;
            ScheduleFeatures dropFeatures = (ScheduleFeatures)feature;
            dropFeatures.setStartDateFeature(this.startDateFeature);
            dropFeatures.setEndDateFeature(this.endDateFeature);
            dropFeatures.setWhen(this.when);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        ScheduleFeaturesEditorManager.getInstance().startEditing(player, this);
    }

    public String getSimpleLocString(Location loc) {
        return loc.getWorld().getName() + "-" + loc.getBlockX() + "-" + loc.getBlockY() + "-" + loc.getBlockZ();
    }

    @Generated
    public UncoloredStringFeature getStartDateFeature() {
        return this.startDateFeature;
    }

    @Generated
    public UncoloredStringFeature getEndDateFeature() {
        return this.endDateFeature;
    }

    @Generated
    public ListUncoloredStringFeature getWhen() {
        return this.when;
    }

    @Generated
    public void setStartDateFeature(UncoloredStringFeature startDateFeature) {
        this.startDateFeature = startDateFeature;
    }

    @Generated
    public void setEndDateFeature(UncoloredStringFeature endDateFeature) {
        this.endDateFeature = endDateFeature;
    }

    @Generated
    public void setWhen(ListUncoloredStringFeature when) {
        this.when = when;
    }
}

