/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject;

import com.ssomar.score.SCore;
import com.ssomar.score.features.custom.variables.base.variable.VariableFeature;
import com.ssomar.score.features.custom.variables.real.VariableRealBuilder;
import com.ssomar.score.features.custom.variables.real.VariableRealsList;
import com.ssomar.score.sobject.SObjectWithVariables;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.itemwriter.NBTWriterReader;
import com.ssomar.score.utils.writer.NameSpaceKeyWriterReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class InternalData {
    private int usage = -1;
    private VariableRealsList variableRealsList = null;
    private Map<String, String> variables = null;
    private UUID ownerUUID = null;

    public InternalData setUsage(int usage) {
        this.usage = usage;
        return this;
    }

    public InternalData setVariableRealsList(VariableRealsList variableRealsList) {
        this.variableRealsList = variableRealsList;
        return this;
    }

    public InternalData setVariables(Map<String, String> variables) {
        this.variables = variables;
        return this;
    }

    public InternalData setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        return this;
    }

    public Optional<Integer> getUsageOptional() {
        if (this.usage == -1) {
            return Optional.empty();
        }
        return Optional.of(this.usage);
    }

    public Optional<UUID> getOwnerUUIDOptional() {
        if (this.ownerUUID == null) {
            return Optional.empty();
        }
        return Optional.of(this.ownerUUID);
    }

    public Optional<Player> getOwnerOptional() {
        if (this.ownerUUID == null) {
            return Optional.empty();
        }
        Player player = Bukkit.getPlayer((UUID)this.ownerUUID);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public Optional<OfflinePlayer> getOfflineOwnerOptional() {
        if (this.ownerUUID == null) {
            return Optional.empty();
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)this.ownerUUID);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public Map<String, String> getVariables() {
        if (this.variableRealsList != null) {
            return this.variableRealsList.getFlatValues();
        }
        if (this.variables == null) {
            return new HashMap<String, String>();
        }
        return this.variables;
    }

    public InternalData clone() {
        InternalData internalData = new InternalData().setUsage(this.usage).setOwnerUUID(this.ownerUUID).setVariables(this.variables).setVariableRealsList(this.variableRealsList);
        return internalData;
    }

    public void loadFromItem(ItemStack item, DynamicMeta dMeta, SObjectWithVariables config) {
        ItemKeyWriterReader reader = ItemKeyWriterReader.init();
        if (reader instanceof NBTWriterReader) {
            NBTWriterReader nbtReader = (NBTWriterReader)reader;
            nbtReader.readInteger((Plugin)SCore.plugin, item, dMeta, "usage").ifPresent(value -> {
                this.usage = value;
            });
            nbtReader.readString((Plugin)SCore.plugin, item, dMeta, "ownerUUID").ifPresent(value -> {
                try {
                    this.ownerUUID = UUID.fromString(value);
                }
                catch (Exception e) {
                    this.ownerUUID = null;
                }
            });
            this.variableRealsList = new VariableRealsList();
            for (VariableFeature vC : config.getVariables().getVariables().values()) {
                this.variableRealsList.add(VariableRealBuilder.build(vC, item, dMeta).get());
            }
        } else {
            this.loadFromItemMeta(dMeta, config);
        }
    }

    public void loadFromItemMeta(DynamicMeta dMeta, SObjectWithVariables config) {
        this.loadFromPersistentDataContainer(dMeta.getMeta().getPersistentDataContainer(), config);
    }

    public void loadFromEntity(Entity entity, SObjectWithVariables config) {
        this.loadFromPersistentDataContainer(entity.getPersistentDataContainer(), config);
    }

    public void loadFromPersistentDataContainer(PersistentDataContainer persistentDataContainer, SObjectWithVariables config) {
        NameSpaceKeyWriterReader.readInteger((Plugin)SCore.plugin, persistentDataContainer, "usage").ifPresent(value -> {
            this.usage = value;
        });
        NameSpaceKeyWriterReader.readString((Plugin)SCore.plugin, persistentDataContainer, "ownerUUID").ifPresent(value -> {
            try {
                this.ownerUUID = UUID.fromString(value);
            }
            catch (Exception e) {
                this.ownerUUID = null;
            }
        });
        this.variableRealsList = new VariableRealsList();
        for (VariableFeature vC : config.getVariables().getVariables().values()) {
            this.variableRealsList.add(VariableRealBuilder.build(vC, persistentDataContainer).get());
        }
    }

    public void saveInEntity(Entity entity) {
        PersistentDataContainer persistentDataContainer = entity.getPersistentDataContainer();
        NameSpaceKeyWriterReader.writeInteger((Plugin)SCore.plugin, persistentDataContainer, "usage", this.usage);
        NameSpaceKeyWriterReader.writeString((Plugin)SCore.plugin, persistentDataContainer, "ownerUUID", this.ownerUUID == null ? "" : this.ownerUUID.toString());
        if (this.variableRealsList != null) {
            this.variableRealsList.save(persistentDataContainer);
        }
    }

    public void save(ConfigurationSection config) {
        config.set("usage", (Object)this.usage);
        Optional<Player> owner = this.getOwnerOptional();
        if (owner.isPresent()) {
            config.set("owner", (Object)owner.get().getName());
        } else {
            config.set("owner", (Object)"OWNER NAME NOT FOUND");
        }
        if (this.ownerUUID != null) {
            config.set("ownerUUID", (Object)this.ownerUUID.toString());
        } else {
            config.set("ownerUUID", null);
            config.set("owner", (Object)"unowned");
        }
        if (this.variableRealsList != null) {
            if (!config.isConfigurationSection("variables")) {
                config.createSection("variables");
            }
            this.variableRealsList.save(config.getConfigurationSection("variables"));
        }
    }

    public VariableRealsList getVariableRealsList() {
        if (this.variableRealsList == null) {
            this.variableRealsList = new VariableRealsList();
        }
        return this.variableRealsList;
    }

    @Generated
    public int getUsage() {
        return this.usage;
    }

    @Generated
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }
}

