/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.placeholders;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.mixed_player_entity.commands.DamageBoost;
import com.ssomar.score.commands.runnable.mixed_player_entity.commands.DamageResistance;
import com.ssomar.score.features.custom.variables.real.VariableReal;
import com.ssomar.score.utils.placeholders.AroundEntityTargetPlaceholders;
import com.ssomar.score.utils.placeholders.AroundPlayerTargetPlaceholders;
import com.ssomar.score.utils.placeholders.BlockPlaceholders;
import com.ssomar.score.utils.placeholders.EffectPlaceholders;
import com.ssomar.score.utils.placeholders.EntityPlaceholders;
import com.ssomar.score.utils.placeholders.OwnerPlaceholders;
import com.ssomar.score.utils.placeholders.PlaceholdersInterface;
import com.ssomar.score.utils.placeholders.PlayerPlaceholders;
import com.ssomar.score.utils.placeholders.ProjectilePlaceholders;
import com.ssomar.score.utils.placeholders.TargetBlockPlaceholders;
import com.ssomar.score.utils.placeholders.TargetEntityPlaceholders;
import com.ssomar.score.utils.placeholders.TargetPlaceholders;
import com.ssomar.score.utils.placeholders.TimePlaceholders;
import com.ssomar.score.utils.strings.StringUtils;
import com.ssomar.score.variables.manager.VariablesManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class StringPlaceholder
extends PlaceholdersInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String start = "\\%";
    public static final String end = "\\%";
    private final PlayerPlaceholders playerPlch = new PlayerPlaceholders();
    private final TargetPlaceholders targetPlch = new TargetPlaceholders();
    private final OwnerPlaceholders ownerPlch = new OwnerPlaceholders();
    private final ProjectilePlaceholders projectilePlch = new ProjectilePlaceholders();
    private final transient TimePlaceholders timePlch = new TimePlaceholders();
    private final EntityPlaceholders entityPlch = new EntityPlaceholders();
    private final TargetEntityPlaceholders targetEntityPlch = new TargetEntityPlaceholders();
    private final BlockPlaceholders blockPlch = new BlockPlaceholders();
    private final TargetBlockPlaceholders targetBlockPlch = new TargetBlockPlaceholders();
    AroundPlayerTargetPlaceholders aroundPlayerTargetPlch = new AroundPlayerTargetPlaceholders();
    AroundEntityTargetPlaceholders aroundEntityTargetPlch = new AroundEntityTargetPlaceholders();
    private final EffectPlaceholders effectPlch = new EffectPlaceholders();
    private String id = "";
    private String name = "";
    private String activator_id = "";
    private String activator_name = "";
    private String quantity = "";
    private String usage = "";
    private String usageLimit = "";
    private String maxUsePerDayItem = "";
    private String maxUsePerDayActivator = "";
    private String launcher = "";
    private String blockface = "";
    private String cooldown = "";
    private List<VariableReal> variables = new ArrayList<VariableReal>();
    private Map<String, String> extraPlaceholders = new HashMap<String, String>();
    private String item = "";
    private String activator = "";

    public static String replaceRandomPlaceholders(String s) {
        String result = s;
        if (result.contains("%rand:")) {
            String[] decompRand = result.split("%rand:");
            boolean cont = true;
            for (String strRand : decompRand) {
                int part2;
                int part1;
                String[] decomp;
                if (cont) {
                    cont = false;
                    continue;
                }
                if (!strRand.contains("%") || (decomp = strRand.split("%")).length < 2 && (!strRand.endsWith("%") || decomp.length != 1) || !decomp[0].contains("|")) continue;
                decomp = decomp[0].split("\\|");
                try {
                    part1 = Integer.parseInt(decomp[0]);
                    part2 = Integer.parseInt(decomp[1]);
                }
                catch (Exception e) {
                    continue;
                }
                if (part1 >= part2) continue;
                int random = part1 + (int)(Math.random() * (double)(part2 - part1 + 1));
                result = result.replace("%rand:" + part1 + "|" + part2 + "%", random + "");
            }
        }
        return result;
    }

    public StringPlaceholder setPlayerPlcHldr(UUID uuid) {
        this.playerPlch.setPlayerPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setPlayerPlcHldr(UUID uuid, int fixSlot) {
        this.playerPlch.setPlayerPlcHldr(uuid, fixSlot);
        return this;
    }

    public StringPlaceholder setTargetPlcHldr(UUID uuid) {
        this.targetPlch.setPlayerPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setOwnerPlcHldr(UUID uuid) {
        this.ownerPlch.setPlayerPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setProjectilePlcHldr(Projectile proj, String blockFace) {
        this.projectilePlch.setProjectilePlcHldr(proj, blockFace);
        return this;
    }

    public StringPlaceholder setEntityPlcHldr(UUID uuid) {
        this.entityPlch.setEntityPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setEntityPlcHldr(Entity entity) {
        this.entityPlch.setEntityPlcHldr(entity);
        return this;
    }

    public StringPlaceholder setTargetEntityPlcHldr(UUID uuid) {
        this.targetEntityPlch.setEntityPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setTargetEntityPlcHldr(Entity entity) {
        this.targetEntityPlch.setEntityPlcHldr(entity);
        return this;
    }

    public StringPlaceholder setBlockPlcHldr(@NotNull Block block) {
        this.blockPlch.setBlockPlcHldr(block);
        return this;
    }

    public StringPlaceholder setBlockPlcHldr(@NotNull Block block, Material fixType) {
        this.blockPlch.setBlockPlcHldr(block, fixType);
        return this;
    }

    public StringPlaceholder setTargetBlockPlcHldr(@NotNull Block block) {
        this.targetBlockPlch.setBlockPlcHldr(block);
        return this;
    }

    public StringPlaceholder setTargetBlockPlcHldr(@NotNull Block block, Material fixType) {
        this.targetBlockPlch.setBlockPlcHldr(block, fixType);
        return this;
    }

    public StringPlaceholder setAroundTargetPlayerPlcHldr(UUID uuid) {
        this.aroundPlayerTargetPlch.setPlayerPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setAroundTargetEntityPlcHldr(UUID uuid) {
        this.aroundEntityTargetPlch.setEntityPlcHldr(uuid);
        return this;
    }

    public StringPlaceholder setEffectPlcHldr(PotionEffect effect) {
        this.effectPlch.setEffectPlcHldr(effect);
        return this;
    }

    public StringPlaceholder reloadAllPlaceholders() {
        this.playerPlch.reloadPlayerPlcHldr();
        this.targetPlch.reloadPlayerPlcHldr();
        this.ownerPlch.reloadPlayerPlcHldr();
        this.entityPlch.reloadEntityPlcHldr();
        if (this.targetEntityPlch != null) {
            this.targetEntityPlch.reloadEntityPlcHldr();
        }
        this.blockPlch.reloadBlockPlcHldr();
        this.targetBlockPlch.reloadBlockPlcHldr();
        this.aroundPlayerTargetPlch.reloadPlayerPlcHldr();
        this.aroundEntityTargetPlch.reloadEntityPlcHldr();
        if (this.effectPlch != null) {
            this.effectPlch.reloadEffectPlcHldr();
        }
        if (this.projectilePlch != null) {
            this.projectilePlch.reloadProjectilePlcHldr();
        }
        return this;
    }

    public List<String> replacePlaceholders(List<String> list) {
        this.reloadAllPlaceholders();
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(this.replacePlaceholderWithoutReload(s, true));
        }
        return result;
    }

    public String replacePlaceholder(String str) {
        if (!str.contains("%")) {
            return str;
        }
        return this.replacePlaceholder(str, true);
    }

    public String replacePlaceholder(String str, boolean withPAPI) {
        if (!str.contains("%")) {
            return str;
        }
        this.reloadAllPlaceholders();
        return this.replacePlaceholderWithoutReload(str, withPAPI);
    }

    public String replacePlaceholderWithoutReload(String str, boolean withPAPI) {
        return this.replacePlaceholderWithoutReload(str, withPAPI, true);
    }

    public String replacePlaceholderWithoutReload(String str, boolean withPAPI, boolean withVariables) {
        String s = str;
        if (!s.contains("%")) {
            return str;
        }
        if (str.trim().isEmpty()) {
            return "";
        }
        s = StringPlaceholder.replaceRandomPlaceholders(s);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (this.hasActivator()) {
            placeholders.put("%activator%", this.getActivator());
        }
        if (this.hasItem()) {
            placeholders.put("%item%", this.getItem());
        }
        if (this.hasId()) {
            placeholders.put("%id%", this.getId());
        }
        if (this.hasName()) {
            placeholders.put("%name%", this.getName());
        }
        if (this.hasActivatorId()) {
            placeholders.put("%activator_id%", this.getActivator_id());
        }
        if (this.hasActivatorName()) {
            placeholders.put("%activator_name%", this.getActivator_name());
        }
        if (this.hasQuantity()) {
            s = StringPlaceholder.replaceCalculPlaceholder(s, "%quantity%", this.quantity, true);
            s = StringPlaceholder.replaceCalculPlaceholder(s, "%amount%", this.quantity, true);
        }
        if (this.hasCoolodwn()) {
            placeholders.put("%cooldown%", this.getCooldown());
        }
        if (this.hasBlockFace()) {
            placeholders.put("%blockface%", this.getBlockface());
        }
        if (this.hasUsage()) {
            s = StringPlaceholder.replaceCalculPlaceholder(s, "%usage%", this.usage, true);
        }
        if (this.hasUsageLimit()) {
            s = StringPlaceholder.replaceCalculPlaceholder(s, "%usage_limit%", this.usageLimit, true);
        }
        if (this.hasMaxUsePerDayActivator()) {
            placeholders.put("%max_use_per_day_activator%", this.getMaxUsePerDayActivator());
        }
        if (this.hasMaxUsePerDayItem()) {
            placeholders.put("%max_use_per_day_item%", this.getMaxUsePerDayItem());
        }
        placeholders.put("%timestamp%", System.currentTimeMillis() - 1667000000000L + "");
        if (withVariables && this.variables != null) {
            for (VariableReal var2 : this.variables) {
                s = var2.replaceVariablePlaceholder(s);
            }
        }
        placeholders.putAll(this.playerPlch.getPlaceholders());
        s = this.playerPlch.replacePlaceholder(s);
        placeholders.putAll(this.targetPlch.getPlaceholders());
        s = this.targetPlch.replacePlaceholder(s);
        placeholders.putAll(this.ownerPlch.getPlaceholders());
        s = this.ownerPlch.replacePlaceholder(s);
        s = this.entityPlch.replacePlaceholder(s);
        placeholders.putAll(this.blockPlch.getPlaceholders());
        s = this.blockPlch.replacePlaceholder(s);
        placeholders.putAll(this.targetBlockPlch.getPlaceholders());
        s = this.targetBlockPlch.replacePlaceholder(s);
        placeholders.putAll(this.aroundPlayerTargetPlch.getPlaceholders());
        s = this.aroundPlayerTargetPlch.replacePlaceholder(s);
        s = this.aroundEntityTargetPlch.replacePlaceholder(s);
        if (this.effectPlch != null) {
            placeholders.putAll(this.effectPlch.getPlaceholders());
            s = this.effectPlch.replacePlaceholder(s);
        }
        if (this.timePlch != null) {
            s = this.timePlch.replacePlaceholder(s);
        }
        if (this.projectilePlch != null) {
            s = this.projectilePlch.replacePlaceholder(s);
        }
        if (this.targetEntityPlch != null) {
            s = this.targetEntityPlch.replacePlaceholder(s);
        }
        if (this.extraPlaceholders != null && !this.extraPlaceholders.isEmpty()) {
            for (String key : this.extraPlaceholders.keySet()) {
                placeholders.put(key, this.extraPlaceholders.get(key));
            }
        }
        String[] keys = placeholders.keySet().toArray(new String[0]);
        String[] values = placeholders.values().toArray(new String[0]);
        s = StringUtils.replaceEach(s, keys, values);
        if (withPAPI) {
            s = this.replacePlaceholderOfPAPI(s);
        }
        s = this.replacePlaceholderOfSCore(s);
        if (withVariables && this.variables != null) {
            for (VariableReal var3 : this.variables) {
                s = var3.replaceVariablePlaceholder(s);
            }
        }
        return s;
    }

    public String replacePlaceholderOfSCore(String s) {
        String replace = s;
        Pattern SCORE_REGEX = Pattern.compile("%score_*");
        Matcher countSCoreMatcher = SCORE_REGEX.matcher(replace);
        int maxReplace = 0;
        while (countSCoreMatcher.find()) {
            ++maxReplace;
        }
        int cpt = 0;
        while (replace.contains("%score_") && cpt < maxReplace) {
            ++cpt;
            UUID uuid = this.playerPlch.getPlayerUUID();
            if (uuid == null) {
                // empty if block
            }
            OfflinePlayer p = null;
            if (uuid != null) {
                p = Bukkit.getOfflinePlayer((UUID)uuid);
            }
            try {
                Optional<String> dmgResistancePlaceHolder;
                String[] split = replace.split("%score_");
                String[] split2 = split[1].split("%");
                String params = split2[0];
                Optional<String> placeholder = VariablesManager.getInstance().onRequestPlaceholder(p, params);
                if (placeholder.isPresent()) {
                    replace = replace.replace("%score_" + params + "%", placeholder.get());
                }
                if (p == null) continue;
                Optional<String> dmgBoosterPlaceHolder = DamageBoost.getInstance().onRequestPlaceholder(p, params);
                if (dmgBoosterPlaceHolder.isPresent()) {
                    replace = replace.replace("%score_" + params + "%", dmgBoosterPlaceHolder.get());
                }
                if (!(dmgResistancePlaceHolder = DamageResistance.getInstance().onRequestPlaceholder(p, params)).isPresent()) continue;
                replace = replace.replace("%score_" + params + "%", dmgResistancePlaceHolder.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        return replace;
    }

    public String replacePlaceholderOfPAPI(String s) {
        String replace = s;
        if (SCore.hasPlaceholderAPI) {
            Player p;
            UUID uuid = this.playerPlch.getPlayerUUID();
            if (uuid == null) {
                if (!Bukkit.getOnlinePlayers().isEmpty()) {
                    uuid = ((Player)Bukkit.getOnlinePlayers().iterator().next()).getUniqueId();
                } else if (Bukkit.getOfflinePlayers().length > 0) {
                    replace = PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayers()[0], (String)replace);
                } else {
                    return replace;
                }
            }
            if (uuid != null && (p = Bukkit.getPlayer((UUID)uuid)) != null) {
                try {
                    replace = PlaceholderAPI.setPlaceholders((Player)p, (String)replace);
                }
                catch (Exception e) {
                    SsomarDev.testMsg(e.getMessage(), true);
                }
                if (replace.contains("%")) {
                    replace = replace.replaceFirst("%", "fAzzAf");
                    replace = PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid), (String)replace);
                    replace = replace.replaceFirst("fAzzAf", "%");
                }
            }
        }
        return replace;
    }

    public static String replacePlaceholderOfPAPI(String s, UUID playerUUID) {
        String replace = s;
        if (SCore.hasPlaceholderAPI) {
            Player p;
            UUID uuid = playerUUID;
            if (playerUUID == null) {
                uuid = !Bukkit.getOnlinePlayers().isEmpty() ? ((Player)Bukkit.getOnlinePlayers().iterator().next()).getUniqueId() : Bukkit.getOfflinePlayers()[0].getUniqueId();
            }
            if ((replace = (p = Bukkit.getPlayer((UUID)uuid)) != null ? PlaceholderAPI.setPlaceholders((Player)p, (String)replace) : PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid), (String)replace)).contains("%")) {
                replace = replace.replaceFirst("%", "fAzzAf");
                replace = PlaceholderAPI.setPlaceholders((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)uuid), (String)replace);
                replace = replace.replaceFirst("fAzzAf", "%");
            }
        }
        return replace;
    }

    public boolean hasActivator() {
        return this.activator.length() != 0;
    }

    public boolean hasId() {
        return this.id != null && this.id.length() != 0;
    }

    public boolean hasName() {
        return this.name != null && this.name.length() != 0;
    }

    public boolean hasActivatorId() {
        return this.activator_id != null && this.activator_id.length() != 0;
    }

    public boolean hasActivatorName() {
        return this.activator_name != null && this.activator_name.length() != 0;
    }

    public boolean hasItem() {
        return this.item.length() != 0;
    }

    public boolean hasQuantity() {
        return this.quantity.length() != 0;
    }

    public boolean hasCoolodwn() {
        return this.cooldown.length() != 0;
    }

    public boolean hasUsageLimit() {
        return this.usageLimit.length() != 0;
    }

    public boolean hasBlockFace() {
        return this.blockface.length() != 0;
    }

    public boolean hasUsage() {
        return this.usage.length() != 0;
    }

    public boolean hasMaxUsePerDayItem() {
        return this.maxUsePerDayItem.length() != 0;
    }

    public boolean hasMaxUsePerDayActivator() {
        return this.maxUsePerDayActivator.length() != 0;
    }

    @Generated
    public TimePlaceholders getTimePlch() {
        return this.timePlch;
    }

    @Generated
    public EntityPlaceholders getEntityPlch() {
        return this.entityPlch;
    }

    @Generated
    public TargetEntityPlaceholders getTargetEntityPlch() {
        return this.targetEntityPlch;
    }

    @Generated
    public BlockPlaceholders getBlockPlch() {
        return this.blockPlch;
    }

    @Generated
    public TargetBlockPlaceholders getTargetBlockPlch() {
        return this.targetBlockPlch;
    }

    @Generated
    public AroundPlayerTargetPlaceholders getAroundPlayerTargetPlch() {
        return this.aroundPlayerTargetPlch;
    }

    @Generated
    public AroundEntityTargetPlaceholders getAroundEntityTargetPlch() {
        return this.aroundEntityTargetPlch;
    }

    @Generated
    public EffectPlaceholders getEffectPlch() {
        return this.effectPlch;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getActivator_id() {
        return this.activator_id;
    }

    @Generated
    public String getActivator_name() {
        return this.activator_name;
    }

    @Generated
    public String getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public String getUsageLimit() {
        return this.usageLimit;
    }

    @Generated
    public String getMaxUsePerDayItem() {
        return this.maxUsePerDayItem;
    }

    @Generated
    public String getMaxUsePerDayActivator() {
        return this.maxUsePerDayActivator;
    }

    @Generated
    public String getLauncher() {
        return this.launcher;
    }

    @Generated
    public String getBlockface() {
        return this.blockface;
    }

    @Generated
    public String getCooldown() {
        return this.cooldown;
    }

    @Generated
    public List<VariableReal> getVariables() {
        return this.variables;
    }

    @Generated
    public Map<String, String> getExtraPlaceholders() {
        return this.extraPlaceholders;
    }

    @Generated
    public String getItem() {
        return this.item;
    }

    @Generated
    public String getActivator() {
        return this.activator;
    }

    @Generated
    public void setAroundPlayerTargetPlch(AroundPlayerTargetPlaceholders aroundPlayerTargetPlch) {
        this.aroundPlayerTargetPlch = aroundPlayerTargetPlch;
    }

    @Generated
    public void setAroundEntityTargetPlch(AroundEntityTargetPlaceholders aroundEntityTargetPlch) {
        this.aroundEntityTargetPlch = aroundEntityTargetPlch;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setActivator_id(String activator_id) {
        this.activator_id = activator_id;
    }

    @Generated
    public void setActivator_name(String activator_name) {
        this.activator_name = activator_name;
    }

    @Generated
    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public void setUsageLimit(String usageLimit) {
        this.usageLimit = usageLimit;
    }

    @Generated
    public void setMaxUsePerDayItem(String maxUsePerDayItem) {
        this.maxUsePerDayItem = maxUsePerDayItem;
    }

    @Generated
    public void setMaxUsePerDayActivator(String maxUsePerDayActivator) {
        this.maxUsePerDayActivator = maxUsePerDayActivator;
    }

    @Generated
    public void setLauncher(String launcher) {
        this.launcher = launcher;
    }

    @Generated
    public void setBlockface(String blockface) {
        this.blockface = blockface;
    }

    @Generated
    public void setCooldown(String cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setVariables(List<VariableReal> variables) {
        this.variables = variables;
    }

    @Generated
    public void setExtraPlaceholders(Map<String, String> extraPlaceholders) {
        this.extraPlaceholders = extraPlaceholders;
    }

    @Generated
    public void setItem(String item) {
        this.item = item;
    }

    @Generated
    public void setActivator(String activator) {
        this.activator = activator;
    }
}

