/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.scheduler;

import com.ssomar.score.utils.scheduler.ScheduledTask;
import com.ssomar.score.utils.scheduler.SchedulerHook;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class RegionisedSchedulerHook
implements SchedulerHook {
    private final Plugin plugin;

    public RegionisedSchedulerHook(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public ScheduledTask runTask(Runnable runnable, long delay) {
        if (delay > 0L) {
            return new RegionisedScheduledTask(((GlobalRegionScheduler)this.getReflectedObjectOfBukkit("getGlobalRegionScheduler")).runDelayed(this.plugin, task -> runnable.run(), delay));
        }
        return new RegionisedScheduledTask(((GlobalRegionScheduler)this.getReflectedObjectOfBukkit("getGlobalRegionScheduler")).run(this.plugin, task -> runnable.run()));
    }

    @Override
    public ScheduledTask runRepeatingTask(Runnable runnable, long initDelay, long period) {
        if (initDelay <= 0L) {
            initDelay = 1L;
        }
        return new RegionisedScheduledTask(((GlobalRegionScheduler)this.getReflectedObjectOfBukkit("getGlobalRegionScheduler")).runAtFixedRate(this.plugin, task -> runnable.run(), initDelay, period));
    }

    @Override
    public ScheduledTask runAsyncTask(Runnable runnable, long delay) {
        if ((delay *= 50L) > 0L) {
            return new RegionisedScheduledTask(((AsyncScheduler)this.getReflectedObjectOfBukkit("getAsyncScheduler")).runDelayed(this.plugin, task -> runnable.run(), delay, TimeUnit.MILLISECONDS));
        }
        return new RegionisedScheduledTask(((AsyncScheduler)this.getReflectedObjectOfBukkit("getAsyncScheduler")).runNow(this.plugin, task -> runnable.run()));
    }

    @Override
    public ScheduledTask runAsyncRepeatingTask(Runnable runnable, long initDelay, long period) {
        period *= 50L;
        if ((initDelay *= 50L) <= 0L) {
            initDelay = 1L;
        }
        return new RegionisedScheduledTask(((AsyncScheduler)this.getReflectedObjectOfBukkit("getAsyncScheduler")).runAtFixedRate(this.plugin, task -> runnable.run(), initDelay, period, TimeUnit.MILLISECONDS));
    }

    @Override
    public ScheduledTask runEntityTask(Runnable runnable, Runnable retired, Entity entity, long delay) {
        io.papermc.paper.threadedregions.scheduler.ScheduledTask scheduledTask = null;
        EntityScheduler scheduler = null;
        try {
            scheduler = (EntityScheduler)Entity.class.getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        scheduledTask = delay > 0L ? scheduler.runDelayed(this.plugin, task -> runnable.run(), retired, delay) : scheduler.run(this.plugin, task -> runnable.run(), retired);
        return scheduledTask == null ? null : new RegionisedScheduledTask(scheduledTask);
    }

    @Override
    public ScheduledTask runEntityTaskAsap(Runnable runnable, Runnable retired, Entity entity) {
        boolean isOwnedByCurrentRegion = false;
        try {
            isOwnedByCurrentRegion = (Boolean)Bukkit.class.getMethod("isOwnedByCurrentRegion", Entity.class).invoke(Bukkit.class, entity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (isOwnedByCurrentRegion) {
            runnable.run();
            return new ScheduledTask(){

                @Override
                public void cancel() {
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        return this.runEntityTask(runnable, retired, entity, 0L);
    }

    @Override
    public ScheduledTask runLocationTask(Runnable runnable, Location location, long delay) {
        io.papermc.paper.threadedregions.scheduler.ScheduledTask scheduledTask = null;
        scheduledTask = delay > 0L ? ((RegionScheduler)this.getReflectedObjectOfBukkit("getRegionScheduler")).runDelayed(this.plugin, location, task -> runnable.run(), delay) : ((RegionScheduler)this.getReflectedObjectOfBukkit("getRegionScheduler")).run(this.plugin, location, task -> runnable.run());
        return scheduledTask == null ? null : new RegionisedScheduledTask(scheduledTask);
    }

    @Override
    public ScheduledTask runLocationTaskAsap(Runnable runnable, Location location) {
        boolean isOwnedByCurrentRegion = false;
        try {
            isOwnedByCurrentRegion = (Boolean)Bukkit.class.getMethod("isOwnedByCurrentRegion", Location.class).invoke(Bukkit.class, location);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        if (isOwnedByCurrentRegion) {
            runnable.run();
            return new ScheduledTask(){

                @Override
                public void cancel() {
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        return this.runLocationTask(runnable, location, 0L);
    }

    public Object getReflectedObjectOfBukkit(String methodName) {
        try {
            return Bukkit.class.getMethod(methodName, new Class[0]).invoke(Bukkit.class, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCompatible() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static class RegionisedScheduledTask
    implements ScheduledTask {
        private final io.papermc.paper.threadedregions.scheduler.ScheduledTask scheduledTask;

        private RegionisedScheduledTask(io.papermc.paper.threadedregions.scheduler.ScheduledTask scheduledTask) {
            this.scheduledTask = scheduledTask;
        }

        @Override
        public void cancel() {
            this.scheduledTask.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledTask.isCancelled();
        }
    }
}

