/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.strings.StringSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentAdd
extends BlockCommand {
    private static final boolean DEBUG = true;

    @Override
    public void run(@Nullable Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        args = new ArrayList<String>(args);
        Map<String, Object> settings = StringSetting.extractSettingsAndRebuildCorrectly(args, 0, Arrays.asList("EI:", "ei:"));
        String amountStr = "1";
        if (args.size() >= 2) {
            amountStr = args.get(1);
        }
        Optional<Double> intOptional = NTools.getDouble(amountStr);
        int amount = intOptional.orElse(1.0).intValue();
        Optional<Integer> slotOptional = Optional.empty();
        if (args.size() >= 3) {
            slotOptional = NTools.getInteger(args.get(2));
        }
        int slot = slotOptional.orElse(-1);
        if (args.size() >= 1) {
            ItemStack item;
            if (!args.get(0).contains("EI:") && !args.get(0).contains("ei:")) {
                item = new ItemStack(Material.valueOf((String)args.get(0).toUpperCase()), amount);
            } else {
                String id = args.get(0).split(":")[1];
                Optional ei = ExecutableItemsManager.getInstance().getExecutableItem(id);
                if (ei.isPresent()) {
                    item = ((ExecutableItemInterface)ei.get()).buildItem(amount, Optional.ofNullable(p), settings);
                } else {
                    return;
                }
            }
            if (block.getState() instanceof Container) {
                Container container = (Container)block.getState();
                Inventory inv = container.getInventory();
                if (slot == -1) {
                    inv.addItem(new ItemStack[]{item});
                } else {
                    ItemStack item2 = inv.getItem(slot);
                    if (item2 == null) {
                        inv.setItem(slot, item);
                    } else if (item2.isSimilar(item)) {
                        item2.setAmount(item2.getAmount() + item.getAmount());
                        inv.setItem(slot, item2);
                    } else {
                        inv.addItem(new ItemStack[]{item});
                    }
                }
            }
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        ArgumentChecker ac3;
        ArgumentChecker ac2;
        if ((args = new ArrayList<String>(args)).size() < 1) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        if (!args.get(0).contains("EI:") && !args.get(0).contains("ei:")) {
            ArgumentChecker ac = ContentAdd.checkMaterial(args.get(0), isFinalVerification, this.getTemplate());
            if (!ac.isValid()) {
                return Optional.of(ac.getError());
            }
        } else {
            StringSetting.extractSettingsAndRebuildCorrectly(args, 0, Arrays.asList("EI:", "ei:"));
        }
        if (args.size() >= 2 && !(ac2 = ContentAdd.checkDouble(args.get(1), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac2.getError());
        }
        if (args.size() >= 3 && !(ac3 = ContentAdd.checkInteger(args.get(2), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac3.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("CONTENT_ADD");
        return names;
    }

    @Override
    public String getTemplate() {
        return "CONTENT_ADD {Item} [Amount] [slot]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

