/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.features.custom.detailedblocks.DetailedBlocks;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.safebreak.SafeBreak;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;

public class InlineMineInCube
extends BlockCommand {
    @Override
    public void run(final Player p, final @NotNull Block block, SCommandToExec sCommandToExec) {
        final List<String> args = sCommandToExec.getOtherArgs();
        final ActionInfo aInfo = sCommandToExec.getActionInfo();
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (aInfo.isEventFromCustomBreakCommand()) {
                    return;
                }
                try {
                    int radius = Integer.parseInt((String)args.get(0));
                    int depth = 1;
                    if (args.size() >= 2) {
                        depth = Integer.parseInt((String)args.get(1));
                    }
                    --depth;
                    boolean drop = true;
                    if (args.size() >= 3) {
                        drop = Boolean.parseBoolean((String)args.get(2));
                    }
                    boolean createBBEvent = true;
                    if (args.size() >= 4) {
                        createBBEvent = Boolean.parseBoolean((String)args.get(3));
                    }
                    BlockFace directionWritten = null;
                    if (args.size() >= 5) {
                        switch (((String)args.get(4)).toLowerCase()) {
                            case "north": 
                            case "n": 
                            case "-z": {
                                directionWritten = BlockFace.NORTH;
                                break;
                            }
                            case "south": 
                            case "s": 
                            case "+z": {
                                directionWritten = BlockFace.SOUTH;
                                break;
                            }
                            case "east": 
                            case "e": 
                            case "+x": {
                                directionWritten = BlockFace.EAST;
                                break;
                            }
                            case "west": 
                            case "w": 
                            case "-x": {
                                directionWritten = BlockFace.WEST;
                                break;
                            }
                            case "up": {
                                directionWritten = BlockFace.UP;
                                break;
                            }
                            case "down": {
                                directionWritten = BlockFace.DOWN;
                            }
                        }
                    }
                    final ArrayList<Material> blackList = new ArrayList<Material>();
                    blackList.add(Material.BEDROCK);
                    blackList.add(Material.AIR);
                    int initX = -radius;
                    int initZ = -radius;
                    int initY = -radius;
                    int maxX = radius;
                    int maxZ = radius;
                    int maxY = radius;
                    BoundingBox bb = new BoundingBox((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)(block.getX() + 1), (double)(block.getY() + 1), (double)(block.getZ() + 1));
                    RayTraceResult rayTraceResult = bb.rayTrace(p.getEyeLocation().toVector(), p.getEyeLocation().getDirection(), 10.0);
                    BlockFace face = null;
                    face = directionWritten == null ? (rayTraceResult != null && rayTraceResult.getHitBlockFace() != null ? rayTraceResult.getHitBlockFace().getOppositeFace() : p.getFacing().getOppositeFace()) : directionWritten;
                    int multiplier = 1;
                    if (face == BlockFace.NORTH) {
                        initZ = 0;
                        maxZ = depth;
                        multiplier = -1;
                    } else if (face == BlockFace.SOUTH) {
                        initZ = 0;
                        maxZ = depth;
                        multiplier = 1;
                    } else if (face == BlockFace.WEST) {
                        initX = 0;
                        maxX = depth;
                        multiplier = -1;
                    } else if (face == BlockFace.EAST) {
                        initX = 0;
                        maxX = depth;
                        multiplier = 1;
                    } else if (face == BlockFace.UP) {
                        initY = 0;
                        maxY = depth;
                        multiplier = 1;
                    } else if (face == BlockFace.DOWN) {
                        initY = 0;
                        maxY = depth;
                        multiplier = -1;
                    }
                    final boolean fDrop = drop;
                    final boolean fCreateBBEvent = createBBEvent;
                    if (radius < 10) {
                        for (int y = initY; y < maxY + 1; ++y) {
                            for (int x = initX; x < maxX + 1; ++x) {
                                for (int z = initZ; z < maxZ + 1; ++z) {
                                    final Block toBreak = block.getWorld().getBlockAt(block.getX() + x * multiplier, block.getY() + y * multiplier, block.getZ() + z * multiplier);
                                    BukkitRunnable runnable = new BukkitRunnable(){

                                        public void run() {
                                            DetailedBlocks whiteList = aInfo.getDetailedBlocks();
                                            if (whiteList != null && !whiteList.isValid(toBreak, Optional.empty(), null, new StringPlaceholder())) {
                                                return;
                                            }
                                            if (!blackList.contains(toBreak.getType())) {
                                                UUID pUUID = p.getUniqueId();
                                                SafeBreak.breakBlockWithEvent(toBreak, pUUID, aInfo.getSlot(), fDrop, fCreateBBEvent, true, BlockBreakEventExtension.BreakCause.MINE_IN_CUBE);
                                            }
                                        }
                                    };
                                    SCore.schedulerHook.runLocationTask((Runnable)runnable, toBreak.getLocation(), 1L);
                                }
                            }
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        SCore.schedulerHook.runTask(runnable3, 1L);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("INLINE_MINEINCUBE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "INLINE_MINEINCUBE {cube_radius} {depth} {ActiveDrop true or false} {create blockBreakEvent true or false} {optional direction}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

