/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.entity.commands;

import com.ssomar.score.SCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Input;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInputEvent;

public class PlayerRideOnEntityManager
implements Listener {
    private static PlayerRideOnEntityManager instance;
    private Map<UUID, Double> riders = new HashMap<UUID, Double>();
    private List<UUID> forwardRiders = new ArrayList<UUID>();

    public PlayerRideOnEntityManager() {
        this.loopForwardRiders();
    }

    public void addRider(UUID uuid, double speed) {
        if (!this.riders.containsKey(uuid)) {
            this.riders.put(uuid, speed);
        }
    }

    @EventHandler
    public void onPlayerInputEvent(PlayerInputEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.riders.containsKey(playerUUID)) {
            Input input = event.getInput();
            if (input.isForward() && !this.forwardRiders.contains(playerUUID)) {
                this.forwardRiders.add(playerUUID);
            } else {
                this.forwardRiders.remove(playerUUID);
            }
            if (input.isJump()) {
                this.makeMountJump(player);
            }
        }
    }

    public void makeMountJump(Player player) {
        Entity mount = player.getVehicle();
        if (mount != null) {
            double jumpHeight = 0.5;
            mount.setVelocity(mount.getVelocity().setY(jumpHeight));
        }
    }

    public void loopForwardRiders() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (UUID uuid : PlayerRideOnEntityManager.this.forwardRiders) {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null || !player.isOnline()) continue;
                    Entity mount = player.getVehicle();
                    if (mount != null) {
                        Location loc = player.getLocation();
                        mount.setRotation(loc.getYaw(), loc.getPitch());
                        double speed = 0.4 * PlayerRideOnEntityManager.this.riders.getOrDefault(uuid, 1.0);
                        double x = -Math.sin(Math.toRadians(loc.getYaw())) * speed;
                        double z = Math.cos(Math.toRadians(loc.getYaw())) * speed;
                        mount.setVelocity(mount.getVelocity().setX(x).setZ(z));
                        continue;
                    }
                    PlayerRideOnEntityManager.this.forwardRiders.remove(uuid);
                    PlayerRideOnEntityManager.this.riders.remove(uuid);
                }
            }
        };
        SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L);
    }

    public static PlayerRideOnEntityManager getInstance() {
        if (instance == null) {
            instance = new PlayerRideOnEntityManager();
        }
        return instance;
    }
}

