/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.safeplace.SafePlace;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class CropsGrowthBoost
extends PlayerCommand {
    public CropsGrowthBoost() {
        CommandSetting radius = new CommandSetting("radius", 0, Integer.class, (Object)5);
        CommandSetting delay = new CommandSetting("delay", 1, Integer.class, (Object)20);
        CommandSetting duration = new CommandSetting("duration", 2, Integer.class, (Object)200);
        CommandSetting chance = new CommandSetting("chance", 3, Integer.class, (Object)100);
        List<CommandSetting> settings = this.getSettings();
        settings.add(radius);
        settings.add(delay);
        settings.add(duration);
        settings.add(chance);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, final Player receiver, SCommandToExec sCommandToExec) {
        final int radius = (Integer)sCommandToExec.getSettingValue("radius");
        final int delay = (Integer)sCommandToExec.getSettingValue("delay");
        final int duration = (Integer)sCommandToExec.getSettingValue("duration");
        int chance = (Integer)sCommandToExec.getSettingValue("chance");
        if (chance > 100) {
            chance = 100;
        }
        if (chance < 0) {
            chance = 0;
        }
        final int finalChance = chance;
        final int[] i = new int[]{0};
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (i[0] >= duration) {
                    ((ScheduledTask)task.get()).cancel();
                } else {
                    CropsGrowthBoost.this.grownAgeableBlocks(receiver.getLocation(), radius, finalChance, receiver);
                    i[0] = i[0] + delay;
                }
            }
        };
        task.set(SCore.schedulerHook.runRepeatingTask(runnable3, 0L, delay));
    }

    public void grownAgeableBlocks(Location start, int radius, int finalChance, Player receiver) {
        for (double x = start.getX() - (double)radius; x <= start.getX() + (double)radius; x += 1.0) {
            for (double y = start.getY() - (double)radius; y <= start.getY() + (double)radius; y += 1.0) {
                for (double z = start.getZ() - (double)radius; z <= start.getZ() + (double)radius; z += 1.0) {
                    Ageable ageable;
                    int random;
                    Location loc = new Location(start.getWorld(), x, y, z);
                    Block block = loc.getBlock();
                    BlockData data = block.getBlockData();
                    if (!(data instanceof Ageable) || (random = new Random().nextInt(100)) > finalChance || receiver == null || !receiver.isOp() && !SafePlace.verifSafePlace(receiver.getUniqueId(), block) || (ageable = (Ageable)data).getAge() >= ageable.getMaximumAge()) continue;
                    ageable.setAge(ageable.getAge() + 1);
                    block.setBlockData((BlockData)ageable);
                }
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("CROPS_GROWTH_BOOST");
        return names;
    }

    @Override
    public String getTemplate() {
        return "CROPS_GROWTH_BOOST radius:5 delay:20 duration:200 chance:100";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

