/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.features.types.list.ListDetailedMaterialFeature;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PickupMagnet
extends PlayerCommand {
    public PickupMagnet() {
        CommandSetting radius = new CommandSetting("radius", 0, Double.class, (Object)5.0);
        CommandSetting duration = new CommandSetting("duration", 1, Integer.class, (Object)100);
        CommandSetting speed = new CommandSetting("speed", 2, Double.class, (Object)0.3);
        CommandSetting itemTypes = new CommandSetting("itemTypes", 3, String.class, (Object)"ALL");
        CommandSetting blacklist = new CommandSetting("blacklist", 4, String.class, (Object)"");
        CommandSetting particleEffect = new CommandSetting("particleEffect", 5, Boolean.class, (Object)true);
        CommandSetting sound = new CommandSetting("sound", 6, Boolean.class, (Object)false);
        CommandSetting velocityMode = new CommandSetting("velocityMode", 7, String.class, (Object)"DIRECT");
        List<CommandSetting> settings = this.getSettings();
        settings.add(radius);
        settings.add(duration);
        settings.add(speed);
        settings.add(itemTypes);
        settings.add(blacklist);
        settings.add(particleEffect);
        settings.add(sound);
        settings.add(velocityMode);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, final Player receiver, SCommandToExec sCommandToExec) {
        SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Command started for player: " + receiver.getName(), true);
        final double radius = (Double)sCommandToExec.getSettingValue("radius");
        int duration = (Integer)sCommandToExec.getSettingValue("duration");
        final double speed = (Double)sCommandToExec.getSettingValue("speed");
        String itemTypesStr = (String)sCommandToExec.getSettingValue("itemTypes");
        String blacklistStr = (String)sCommandToExec.getSettingValue("blacklist");
        final boolean particleEffect = (Boolean)sCommandToExec.getSettingValue("particleEffect");
        final boolean playSound = (Boolean)sCommandToExec.getSettingValue("sound");
        final String velocityMode = (String)sCommandToExec.getSettingValue("velocityMode");
        SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Parameters: radius=" + radius + ", duration=" + duration + ", speed=" + speed + ", itemTypes=" + itemTypesStr + ", blacklist=" + blacklistStr + ", particles=" + particleEffect + ", sound=" + playSound + ", mode=" + velocityMode, true);
        final ListDetailedMaterialFeature whitelist = new ListDetailedMaterialFeature(false);
        if (!itemTypesStr.isEmpty() && !itemTypesStr.equalsIgnoreCase("ALL")) {
            List<String> whitelistEntries = Arrays.asList(itemTypesStr.split(","));
            whitelist.load((SPlugin)SCore.plugin, whitelistEntries, true);
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Whitelist loaded: " + whitelist.getValues().size() + " entries", true);
        } else {
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] No whitelist (accepting ALL items)", true);
        }
        final ListDetailedMaterialFeature blacklist = new ListDetailedMaterialFeature(false);
        if (!blacklistStr.isEmpty()) {
            List<String> blacklistEntries = Arrays.asList(blacklistStr.split(","));
            blacklist.load((SPlugin)SCore.plugin, blacklistEntries, true);
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Blacklist loaded: " + blacklist.getValues().size() + " entries", true);
        } else {
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] No blacklist", true);
        }
        if (duration == 0) {
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Using instant pulse mode", true);
            this.pullItems(receiver, radius, speed, whitelist, blacklist, particleEffect, playSound, velocityMode);
            return;
        }
        if (duration < 0) {
            duration = Integer.MAX_VALUE;
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Using permanent mode", true);
        } else {
            SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Using duration mode: " + duration + " ticks", true);
        }
        final int finalDuration = duration;
        final int[] ticksElapsed = new int[]{0};
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ticksElapsed[0] >= finalDuration || !receiver.isOnline() || receiver.isDead()) {
                    if (task.get() != null) {
                        ((ScheduledTask)task.get()).cancel();
                    }
                    SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Task ended. Ticks elapsed: " + ticksElapsed[0], true);
                } else {
                    PickupMagnet.this.pullItems(receiver, radius, speed, whitelist, blacklist, particleEffect, playSound, velocityMode);
                    ticksElapsed[0] = ticksElapsed[0] + 1;
                }
            }
        };
        task.set(SCore.schedulerHook.runRepeatingTask(runnable, 0L, 1L));
    }

    private void pullItems(Player receiver, double radius, double speed, ListDetailedMaterialFeature whitelist, ListDetailedMaterialFeature blacklist, boolean particleEffect, boolean playSound, String velocityMode) {
        Location playerLoc = receiver.getLocation().add(0.0, 1.0, 0.0);
        boolean itemPulled = false;
        int totalEntities = 0;
        int itemEntities = 0;
        int tooClose = 0;
        int whitelistFiltered = 0;
        int blacklistFiltered = 0;
        int pulled = 0;
        for (Entity entity : receiver.getNearbyEntities(radius, radius, radius)) {
            ++totalEntities;
            if (!(entity instanceof Item)) continue;
            ++itemEntities;
            Item item = (Item)entity;
            if (item.getLocation().distance(playerLoc) < 1.0) {
                ++tooClose;
                continue;
            }
            if (!whitelist.getValues().isEmpty() && !whitelist.verifItem(item.getItemStack())) {
                ++whitelistFiltered;
                SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Filtered by whitelist: " + item.getItemStack().getType(), true);
                continue;
            }
            if (!blacklist.getValues().isEmpty() && blacklist.verifItem(item.getItemStack())) {
                ++blacklistFiltered;
                SsomarDev.testMsg("\u00a7e[PICKUP_MAGNET] Filtered by blacklist: " + item.getItemStack().getType(), true);
                continue;
            }
            Vector direction = playerLoc.toVector().subtract(item.getLocation().toVector()).normalize();
            if (velocityMode.equalsIgnoreCase("CURVED")) {
                direction.setY(direction.getY() + 0.2);
            }
            Vector velocity = direction.multiply(speed);
            item.setVelocity(velocity);
            if (item.getPickupDelay() > 0) {
                item.setPickupDelay(0);
            }
            SsomarDev.testMsg("\u00a7a[PICKUP_MAGNET] Pulling item: " + item.getItemStack().getType() + " x" + item.getItemStack().getAmount() + " from distance: " + String.format("%.2f", item.getLocation().distance(playerLoc)), true);
            if (particleEffect) {
                Location itemLoc = item.getLocation();
                Vector particleVector = playerLoc.toVector().subtract(itemLoc.toVector()).normalize().multiply(0.5);
                for (int i = 0; i < 3; ++i) {
                    Location particleLoc = itemLoc.clone().add(particleVector.clone().multiply(i));
                    try {
                        receiver.getWorld().spawnParticle(Particle.PORTAL, particleLoc, 1, 0.1, 0.1, 0.1, 0.0);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
            }
            itemPulled = true;
            ++pulled;
        }
        SsomarDev.testMsg("\u00a7b[PICKUP_MAGNET] Summary: total=" + totalEntities + ", items=" + itemEntities + ", tooClose=" + tooClose + ", whitelist=" + whitelistFiltered + ", blacklist=" + blacklistFiltered + ", pulled=" + pulled, true);
        if (playSound && itemPulled) {
            try {
                receiver.playSound(receiver.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.3f, 1.5f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("PICKUP_MAGNET");
        names.add("ITEM_MAGNET");
        names.add("PULL_ITEMS");
        return names;
    }

    @Override
    public String getTemplate() {
        return "PICKUP_MAGNET radius:5.0 duration:100 speed:0.3 itemTypes:ALL blacklist: particleEffect:true sound:false velocityMode:DIRECT";
    }

    @Override
    public ChatColor getColor() {
        return ChatColor.AQUA;
    }

    @Override
    public ChatColor getExtraColor() {
        return ChatColor.DARK_AQUA;
    }
}

