/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions;

import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.commands.console.ConsoleCommandsFeature;
import com.ssomar.score.features.custom.conditions.ConditionRequest;
import com.ssomar.score.features.custom.conditions.FeatureSettingConditions;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.MakeItemGlow;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public abstract class ConditionFeature<Y extends FeatureAbstract, T extends ConditionFeature<Y, T>>
extends FeatureWithHisOwnEditor<T, T, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private Y condition;
    private ColoredStringFeature errorMessage;
    private BooleanFeature cancelEventIfError;
    private ConsoleCommandsFeature consoleCommandsIfError;
    private BooleanFeature silenceOutput;
    private boolean cancelDefaultValue = false;
    private static Optional<String> DEFAULT_DEFAULT_ERROR = Optional.of("&4[ERROR] &cYou can't activate this item > invalid condition");

    public ConditionFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    public ConditionFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, boolean cancelDefaultValue) {
        super(parent, featureSettings);
        this.cancelDefaultValue = cancelDefaultValue;
        this.reset();
    }

    @Override
    public Material getEditorMaterial() {
        return super.getEditorMaterial() == null ? Material.ANVIL : super.getEditorMaterial();
    }

    @Override
    public void reset() {
        this.errorMessage = new ColoredStringFeature(this, DEFAULT_DEFAULT_ERROR, FeatureSettingConditions.getInstance().getErrorMessage(this.getFeatureSettings().getName()));
        this.cancelEventIfError = new BooleanFeature(this, this.cancelDefaultValue, FeatureSettingConditions.getInstance().getCancelEventIfError(this.getFeatureSettings().getName()));
        this.consoleCommandsIfError = new ConsoleCommandsFeature(this, FeatureSettingConditions.getInstance().getConsoleCommandsIfError(this.getFeatureSettings().getName()), true);
        this.silenceOutput = new BooleanFeature(this, false, FeatureSettingsSCore.silenceOutput);
        this.subReset();
    }

    public abstract void subReset();

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        error.addAll(this.condition.load(plugin, config, isPremiumLoading));
        error.addAll(this.errorMessage.load(plugin, config, isPremiumLoading));
        error.addAll(this.cancelEventIfError.load(plugin, config, isPremiumLoading));
        error.addAll(this.consoleCommandsIfError.load(plugin, config, isPremiumLoading));
        error.addAll(this.silenceOutput.load(plugin, config, isPremiumLoading));
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.condition.save(config);
        this.errorMessage.save(config);
        this.cancelEventIfError.save(config);
        this.consoleCommandsIfError.save(config);
        this.silenceOutput.save(config);
    }

    public abstract boolean hasCondition();

    public void addInErrorsInRequest(ConditionRequest request) {
        if (this.hasErrorMsg()) {
            request.getErrors().add((String)((Optional)this.errorMessage.getValue()).get());
        }
    }

    public boolean hasErrorMsg() {
        return ((Optional)this.errorMessage.getValue()).isPresent() && StringConverter.decoloredString(((String)((Optional)this.errorMessage.getValue()).get()).trim()).length() > 0;
    }

    public void cancelEvent(ConditionRequest request) {
        Event event = request.getEvent();
        if (event != null && this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
            ((Cancellable)event).setCancelled(true);
        }
    }

    public void runInvalidCondition(ConditionRequest request) {
        this.addInErrorsInRequest(request);
        this.cancelEvent(request);
        ActionInfo actionInfo = new ActionInfo("", request.getSp());
        actionInfo.setSilenceOutput(this.silenceOutput.getValue());
        this.consoleCommandsIfError.runCommands(actionInfo, "");
    }

    public T initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 5];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = this.hasCondition() ? "&7Enable: &a&l\u2714" : "&7Enable: &c&l\u2718";
        finalDescription[finalDescription.length - 4] = ((Optional)this.getErrorMessage().getValue()).isPresent() ? "&7Error Message: &e" + (String)((Optional)this.getErrorMessage().getValue()).get() : "&7Error Message: &cNO MESSAGE";
        finalDescription[finalDescription.length - 3] = this.getCancelEventIfError().getValue() != false ? "&7Cancel Event If Error: &a&l\u2714" : "&7Cancel Event If Error: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = "&7Console commands If Error: &e" + this.consoleCommandsIfError.getCurrentValues().size();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        for (int i = 0; i < finalDescription.length; ++i) {
            String command = finalDescription[i];
            if (command == null) {
                command = "";
            }
            if (command.length() > 40) {
                command = command.substring(0, 39) + "...";
            }
            finalDescription[i] = command;
        }
        ItemStack item = new ItemStack(this.getEditorMaterial());
        if (this.hasCondition()) {
            ItemMeta meta = item.getItemMeta();
            meta = MakeItemGlow.makeGlow(meta);
            item.setItemMeta(meta);
        }
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return (T)this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    public T clone(FeatureParentInterface newParent) {
        T clone = this.getNewInstance(newParent);
        ((ConditionFeature)clone).setCondition((FeatureAbstract)((FeatureAbstract)((FeatureAbstract)this.condition).clone((FeatureParentInterface)clone)));
        ((ConditionFeature)clone).setErrorMessage(this.errorMessage.clone((FeatureParentInterface)clone));
        ((ConditionFeature)clone).setCancelEventIfError(this.cancelEventIfError.clone((FeatureParentInterface)clone));
        ((ConditionFeature)clone).setConsoleCommandsIfError(this.consoleCommandsIfError.clone((FeatureParentInterface)clone));
        ((ConditionFeature)clone).setSilenceOutput(this.silenceOutput.clone((FeatureParentInterface)clone));
        return clone;
    }

    public abstract T getNewInstance(FeatureParentInterface var1);

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.condition, this.errorMessage, this.cancelEventIfError, this.consoleCommandsIfError, this.silenceOutput));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (feature.getClass() != this.getNewInstance(this.getParent()).getClass() || !feature.getName().equals(this.getName())) continue;
            ConditionFeature cdt = (ConditionFeature)feature;
            cdt.setCondition(this.condition);
            cdt.setErrorMessage(this.errorMessage);
            cdt.setCancelEventIfError(this.cancelEventIfError);
            cdt.setConsoleCommandsIfError(this.consoleCommandsIfError);
            cdt.setSilenceOutput(this.silenceOutput);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public Y getCondition() {
        return this.condition;
    }

    @Generated
    public ColoredStringFeature getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public BooleanFeature getCancelEventIfError() {
        return this.cancelEventIfError;
    }

    @Generated
    public ConsoleCommandsFeature getConsoleCommandsIfError() {
        return this.consoleCommandsIfError;
    }

    @Generated
    public BooleanFeature getSilenceOutput() {
        return this.silenceOutput;
    }

    @Generated
    public boolean isCancelDefaultValue() {
        return this.cancelDefaultValue;
    }

    @Generated
    public void setCondition(Y condition) {
        this.condition = condition;
    }

    @Generated
    public void setErrorMessage(ColoredStringFeature errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setCancelEventIfError(BooleanFeature cancelEventIfError) {
        this.cancelEventIfError = cancelEventIfError;
    }

    @Generated
    public void setConsoleCommandsIfError(ConsoleCommandsFeature consoleCommandsIfError) {
        this.consoleCommandsIfError = consoleCommandsIfError;
    }

    @Generated
    public void setSilenceOutput(BooleanFeature silenceOutput) {
        this.silenceOutput = silenceOutput;
    }

    @Generated
    public void setCancelDefaultValue(boolean cancelDefaultValue) {
        this.cancelDefaultValue = cancelDefaultValue;
    }
}

