/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.givefirstjoin;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GiveFirstJoinFeatures
extends FeatureWithHisOwnEditor<GiveFirstJoinFeatures, GiveFirstJoinFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature giveFirstJoin;
    private IntegerFeature giveFirstJoinAmount;
    private IntegerFeature giveFirstJoinSlot;

    public GiveFirstJoinFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.giveFirstJoinFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.giveFirstJoin = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.giveFirstJoin);
        this.giveFirstJoinAmount = new IntegerFeature(this.getParent(), Optional.of(1), FeatureSettingsSCore.giveFirstJoinAmount);
        this.giveFirstJoinSlot = new IntegerFeature(this.getParent(), Optional.of(0), FeatureSettingsSCore.giveFirstJoinSlot);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            this.giveFirstJoin.load(plugin, section, isPremiumLoading);
            this.giveFirstJoinAmount.load(plugin, section, isPremiumLoading);
            this.giveFirstJoinSlot.load(plugin, section, isPremiumLoading);
        }
        return error;
    }

    public void giveFirstJoin(@NotNull Player player) {
        if (this.giveFirstJoin.getValue().booleanValue() && this.getParent() instanceof SObjectBuildable) {
            SObjectBuildable object = (SObjectBuildable)((Object)this.getParent());
            ItemStack item = object.buildItem((int)((Integer)((Optional)this.giveFirstJoinAmount.getValue()).get()), Optional.of(player));
            player.getInventory().setItem(((Integer)((Optional)this.giveFirstJoinSlot.getValue()).get()).intValue(), item);
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.giveFirstJoin.save(section);
        this.giveFirstJoinAmount.save(section);
        this.giveFirstJoinSlot.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public GiveFirstJoinFeatures getValue() {
        return this;
    }

    @Override
    public GiveFirstJoinFeatures initItemParentEditor(GUI gui, int slot) {
        int toAdd = 2;
        if (this.getGiveFirstJoin().getValue().booleanValue()) {
            toAdd += 2;
        }
        String[] finalDescription = new String[this.getEditorDescription().length + toAdd];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        if (this.getGiveFirstJoin().getValue().booleanValue()) {
            finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
            finalDescription[finalDescription.length - 3] = "&7Enable: &a&l\u2714";
            finalDescription[finalDescription.length - 2] = "&7Amount: &e" + ((Optional)this.getGiveFirstJoinAmount().getValue()).get();
            finalDescription[finalDescription.length - 1] = "&7Slot: &e" + ((Optional)this.getGiveFirstJoinSlot().getValue()).get();
        } else {
            finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
            finalDescription[finalDescription.length - 1] = "&7Enable: &c&l\u2718";
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public GiveFirstJoinFeatures clone(FeatureParentInterface newParent) {
        GiveFirstJoinFeatures giveFirstJoinFeatures = new GiveFirstJoinFeatures(newParent);
        giveFirstJoinFeatures.setGiveFirstJoin(this.giveFirstJoin.clone(giveFirstJoinFeatures));
        giveFirstJoinFeatures.setGiveFirstJoinAmount(this.giveFirstJoinAmount.clone(giveFirstJoinFeatures));
        giveFirstJoinFeatures.setGiveFirstJoinSlot(this.giveFirstJoinSlot.clone(giveFirstJoinFeatures));
        return giveFirstJoinFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.giveFirstJoin, this.giveFirstJoinAmount, this.giveFirstJoinSlot));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof GiveFirstJoinFeatures)) continue;
            GiveFirstJoinFeatures giveFirstJoinFeatures = (GiveFirstJoinFeatures)feature;
            giveFirstJoinFeatures.setGiveFirstJoin(this.giveFirstJoin);
            giveFirstJoinFeatures.setGiveFirstJoinAmount(this.giveFirstJoinAmount);
            giveFirstJoinFeatures.setGiveFirstJoinSlot(this.giveFirstJoinSlot);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getGiveFirstJoin() {
        return this.giveFirstJoin;
    }

    @Generated
    public IntegerFeature getGiveFirstJoinAmount() {
        return this.giveFirstJoinAmount;
    }

    @Generated
    public IntegerFeature getGiveFirstJoinSlot() {
        return this.giveFirstJoinSlot;
    }

    @Generated
    public void setGiveFirstJoin(BooleanFeature giveFirstJoin) {
        this.giveFirstJoin = giveFirstJoin;
    }

    @Generated
    public void setGiveFirstJoinAmount(IntegerFeature giveFirstJoinAmount) {
        this.giveFirstJoinAmount = giveFirstJoinAmount;
    }

    @Generated
    public void setGiveFirstJoinSlot(IntegerFeature giveFirstJoinSlot) {
        this.giveFirstJoinSlot = giveFirstJoinSlot;
    }
}

