/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.ifhas.items.group;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.ifhas.items.attribute.HasItemFeature;
import com.ssomar.score.features.custom.ifhas.items.group.HasItemGroupFeatureEditor;
import com.ssomar.score.features.custom.ifhas.items.group.HasItemGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HasItemGroupFeature
extends FeatureWithHisOwnEditor<HasItemGroupFeature, HasItemGroupFeature, HasItemGroupFeatureEditor, HasItemGroupFeatureEditorManager>
implements FeaturesGroup<FeatureInterface> {
    private Map<String, FeatureInterface> hasItems;
    private boolean notSaveIfNoValue;
    private String multipleChoicesID;

    public HasItemGroupFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings, boolean notSaveIfNoValue) {
        super(parent, featureSettings);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    public HasItemGroupFeature(FeatureParentInterface parent, String multipleChoicesID) {
        super(parent, FeatureSettingsSCore.multiChoices);
        this.notSaveIfNoValue = true;
        this.multipleChoicesID = multipleChoicesID;
        this.reset();
    }

    @Override
    public void reset() {
        this.hasItems = new HashMap<String, FeatureInterface>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        String section = this.multipleChoicesID == null || this.multipleChoicesID.isEmpty() ? this.getName() : this.multipleChoicesID + ".multi-choices";
        if (config.isConfigurationSection(section)) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(section);
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                ConfigurationSection cdtSection = enchantmentsSection.getConfigurationSection(attributeID);
                List<Object> subErrors = new ArrayList();
                if (cdtSection.isConfigurationSection("multi-choices")) {
                    HasItemGroupFeature multiChoices = new HasItemGroupFeature((FeatureParentInterface)this, attributeID);
                    multiChoices.load(plugin, enchantmentsSection, isPremiumLoading);
                    this.hasItems.put(attributeID, multiChoices);
                } else {
                    HasItemFeature attribute = new HasItemFeature((FeatureParentInterface)this, attributeID);
                    subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                    this.hasItems.put(attributeID, attribute);
                }
                if (subErrors.size() <= 0) continue;
                error.addAll(subErrors);
            }
        }
        return error;
    }

    public boolean verifHas(ItemStack[] items, int heldSlot) {
        for (FeatureInterface feature : this.hasItems.values()) {
            if (feature instanceof HasItemFeature) {
                if (this.verifHasItem(items, heldSlot, (HasItemFeature)feature)) continue;
                return false;
            }
            if (!(feature instanceof HasItemGroupFeature)) continue;
            HasItemGroupFeature f = (HasItemGroupFeature)feature;
            boolean has = false;
            for (FeatureInterface feature1 : f.getHasItems().values()) {
                if (feature1 instanceof HasItemFeature) {
                    if (!this.verifHasItem(items, heldSlot, (HasItemFeature)feature1)) continue;
                    has = true;
                    continue;
                }
                if (!(feature1 instanceof HasItemGroupFeature) || this.verifHas(items, heldSlot)) continue;
                return false;
            }
            if (has) continue;
            return false;
        }
        return true;
    }

    public boolean verifHasItem(ItemStack[] items, int heldSlot, HasItemFeature f) {
        boolean valid = false;
        int needed = (Integer)((Optional)f.getAmount().getValue()).get();
        int slot = 0;
        for (ItemStack item : items) {
            if (f.getDetailedSlots().verifSlot(slot, slot == heldSlot) && item != null && item.getType().equals(((Optional)f.getMaterial().getValue()).get())) {
                needed -= item.getAmount();
            }
            if (needed <= 0) {
                valid = true;
                break;
            }
            ++slot;
        }
        return valid;
    }

    public boolean verifHasNot(ItemStack[] items, int heldSlot) {
        return !this.verifHas(items, heldSlot);
    }

    @Override
    public void save(ConfigurationSection config) {
        ConfigurationSection attributesSection;
        if (this.multipleChoicesID == null || this.multipleChoicesID.isEmpty()) {
            config.set(this.getName(), null);
            if (this.notSaveIfNoValue && this.hasItems.size() == 0) {
                return;
            }
            attributesSection = config.createSection(this.getName());
        } else {
            config.set(this.getMultipleChoicesID(), null);
            attributesSection = config.createSection(this.getMultipleChoicesID() + ".multi-choices");
        }
        for (String enchantmentID : this.hasItems.keySet()) {
            this.hasItems.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public HasItemGroupFeature getValue() {
        return this;
    }

    @Override
    public HasItemGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oHasItems(s) added: &e" + this.hasItems.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public FeatureInterface getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (FeatureInterface x : this.hasItems.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public HasItemGroupFeature clone(FeatureParentInterface newParent) {
        HasItemGroupFeature eF = new HasItemGroupFeature(newParent, this.getFeatureSettings(), this.isNotSaveIfNoValue());
        HashMap<String, FeatureInterface> newHasExecutableItems = new HashMap<String, FeatureInterface>();
        for (String key : this.hasItems.keySet()) {
            newHasExecutableItems.put(key, this.hasItems.get(key).clone(eF));
        }
        eF.setHasItems(newHasExecutableItems);
        eF.setMultipleChoicesID(this.getMultipleChoicesID());
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.hasItems.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (this.multipleChoicesID == null || this.multipleChoicesID.isEmpty()) {
            if (section.isConfigurationSection(this.getName())) {
                return section.getConfigurationSection(this.getName());
            }
            return section.createSection(this.getName());
        }
        if (section.isConfigurationSection(this.getMultipleChoicesID() + ".multi-choices")) {
            return section.getConfigurationSection(this.getMultipleChoicesID() + ".multi-choices");
        }
        return section.createSection(this.getMultipleChoicesID() + ".multi-choices");
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof HasItemGroupFeature)) continue;
            HasItemGroupFeature eF = (HasItemGroupFeature)feature;
            eF.setHasItems(this.getHasItems());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        HasItemGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "hasItem";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.hasItems.containsKey(id)) continue;
            HasItemFeature eF = new HasItemFeature((FeatureParentInterface)this, id);
            this.hasItems.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, FeatureInterface feature) {
        if (feature instanceof HasItemFeature) {
            HasItemFeature eF = (HasItemFeature)feature;
            this.hasItems.remove(eF.getId());
        } else if (feature instanceof HasItemGroupFeature) {
            HasItemGroupFeature eF = (HasItemGroupFeature)feature;
            this.hasItems.remove(eF.getMultipleChoicesID());
        }
    }

    @Generated
    public Map<String, FeatureInterface> getHasItems() {
        return this.hasItems;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public String getMultipleChoicesID() {
        return this.multipleChoicesID;
    }

    @Generated
    public void setHasItems(Map<String, FeatureInterface> hasItems) {
        this.hasItems = hasItems;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }

    @Generated
    public void setMultipleChoicesID(String multipleChoicesID) {
        this.multipleChoicesID = multipleChoicesID;
    }
}

