/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.CompoundNBTTag;
import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTCompoundList;
import de.tr7zw.nbtapi.NBTListCompound;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.nbtapi.iface.ReadWriteNBTCompoundList;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class ListCompoundNBTTag
extends NBTTag {
    private List<CompoundNBTTag> values;

    public ListCompoundNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public ListCompoundNBTTag(String key, NBTCompoundList entries) {
        super(key);
        this.values = new ArrayList<CompoundNBTTag>();
        int i = 0;
        for (Object s : entries.toArray()) {
            NBTCompound compound = (NBTCompound)s;
            this.values.add(new CompoundNBTTag("comp" + i, compound));
            ++i;
        }
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        ReadWriteNBTCompoundList list = nbtItem.getCompoundList(this.getKey());
        boolean different = false;
        for (CompoundNBTTag s : this.values) {
            ReadWriteNBT nbtListCompound = list.addCompound();
            for (NBTTag t : s.getNbtTags()) {
                different = different || t.applyTo(nbtListCompound, onlyIfDifferent);
            }
        }
        return different;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        NBTCompoundList list = nbtCompound.getCompoundList(this.getKey());
        boolean different = false;
        for (CompoundNBTTag s : this.values) {
            NBTListCompound nbtListCompound = list.addCompound();
            for (NBTTag t : s.getNbtTags()) {
                different = different || t.applyTo((NBTCompound)nbtListCompound, onlyIfDifferent);
            }
        }
        return different;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"COMPOUND_LIST");
        int i = 0;
        for (CompoundNBTTag s : this.values) {
            ConfigurationSection section = configurationSection.createSection("nbt." + index + ".value." + i);
            section.set("key", (Object)("comp" + i));
            s.saveValueInConfig(section, 0);
            ++i;
        }
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.values = new ArrayList<CompoundNBTTag>();
        ConfigurationSection section = configurationSection.getConfigurationSection("value");
        for (String s : section.getKeys(false)) {
            String key = section.getString(s + ".key");
            if (!section.isConfigurationSection(s + ".nbt.0")) continue;
            ConfigurationSection tagSection = section.getConfigurationSection(s + ".nbt.0");
            tagSection.set("key", (Object)key);
            this.values.add(new CompoundNBTTag(tagSection));
        }
    }

    @Generated
    public List<CompoundNBTTag> getValues() {
        return this.values;
    }
}

