/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.rarity;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ItemRarityFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemRarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RarityFeatures
extends FeatureWithHisOwnEditor<RarityFeatures, RarityFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature enableRarity;
    private ItemRarityFeature itemRarity;

    public RarityFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.itemRarity);
        this.reset();
    }

    @Override
    public void reset() {
        this.enableRarity = new BooleanFeature(this, false, FeatureSettingsSCore.enableRarity);
        this.itemRarity = new ItemRarityFeature(this, Optional.of(ItemRarity.COMMON), FeatureSettingsSCore.rarity);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            error.addAll(this.enableRarity.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
            error.addAll(this.itemRarity.load(plugin, config.getConfigurationSection(this.getName()), isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.enableRarity.save(section);
        this.itemRarity.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public RarityFeatures getValue() {
        return this;
    }

    @Override
    public RarityFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = this.enableRarity.getValue() != false ? "&7Enable rarity: &a&l\u2714" : "&7Enable rarity: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = "&7Rarity: &e" + ((Optional)this.itemRarity.getValue()).get();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RarityFeatures clone(FeatureParentInterface newParent) {
        RarityFeatures dropFeatures = new RarityFeatures(newParent);
        dropFeatures.enableRarity = this.enableRarity.clone(dropFeatures);
        dropFeatures.itemRarity = this.itemRarity.clone(dropFeatures);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enableRarity);
        features.add(this.itemRarity);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RarityFeatures)) continue;
            RarityFeatures dropFeatures = (RarityFeatures)feature;
            dropFeatures.setEnableRarity(this.enableRarity);
            dropFeatures.setItemRarity(this.itemRarity);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public String getSimpleLocString(Location loc) {
        return loc.getWorld().getName() + "-" + loc.getBlockX() + "-" + loc.getBlockY() + "-" + loc.getBlockZ();
    }

    @Nullable
    public ItemRarity getItemRarityValue() {
        if (this.enableRarity.getValue().booleanValue()) {
            return (ItemRarity)((Optional)this.itemRarity.getValue()).get();
        }
        return null;
    }

    @Generated
    public BooleanFeature getEnableRarity() {
        return this.enableRarity;
    }

    @Generated
    public ItemRarityFeature getItemRarity() {
        return this.itemRarity;
    }

    @Generated
    public void setEnableRarity(BooleanFeature enableRarity) {
        this.enableRarity = enableRarity;
    }

    @Generated
    public void setItemRarity(ItemRarityFeature itemRarity) {
        this.itemRarity = itemRarity;
    }
}

