/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.toolrules.toolrule;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.list.ListDetailedMaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ToolRuleFeature
extends FeatureWithHisOwnEditor<ToolRuleFeature, ToolRuleFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private ListDetailedMaterialFeature materials;
    private DoubleFeature miningSpeed;
    private BooleanFeature correctForDrops;
    private String id;

    public ToolRuleFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.toolRule);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.miningSpeed = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.miningSpeed);
        this.correctForDrops = new BooleanFeature(this, false, FeatureSettingsSCore.correctForDrops);
        this.materials = new ListDetailedMaterialFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.materials, true);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.miningSpeed.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.correctForDrops.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.materials.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Tool rule with its options because there is not a section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.miningSpeed.save(attributeConfig);
        this.correctForDrops.save(attributeConfig);
        this.materials.save(attributeConfig);
    }

    @Override
    public ToolRuleFeature getValue() {
        return this;
    }

    @Override
    public ToolRuleFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 5];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 5] = "&7&oSpeed: &e" + ((Optional)this.miningSpeed.getValue()).get();
        finalDescription[finalDescription.length - 4] = "&7&oCorrectForDrops: &e" + this.correctForDrops.getValue();
        finalDescription[finalDescription.length - 3] = "&7&oMaterials: &e" + this.materials.getCurrentValues().toString();
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = GUI.SHIFT_CLICK_TO_REMOVE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ToolRuleFeature clone(FeatureParentInterface newParent) {
        ToolRuleFeature eF = new ToolRuleFeature(newParent, this.id);
        eF.setMiningSpeed(this.miningSpeed.clone(eF));
        eF.setCorrectForDrops(this.correctForDrops.clone(eF));
        eF.setMaterials(this.materials.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.materials, this.miningSpeed, this.correctForDrops));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            ToolRuleFeature aFOF;
            if (!(feature instanceof ToolRuleFeature) || !(aFOF = (ToolRuleFeature)feature).getId().equals(this.id)) continue;
            aFOF.setMiningSpeed(this.miningSpeed);
            aFOF.setCorrectForDrops(this.correctForDrops);
            aFOF.setMaterials(this.materials);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public ListDetailedMaterialFeature getMaterials() {
        return this.materials;
    }

    @Generated
    public DoubleFeature getMiningSpeed() {
        return this.miningSpeed;
    }

    @Generated
    public BooleanFeature getCorrectForDrops() {
        return this.correctForDrops;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setMaterials(ListDetailedMaterialFeature materials) {
        this.materials = materials;
    }

    @Generated
    public void setMiningSpeed(DoubleFeature miningSpeed) {
        this.miningSpeed = miningSpeed;
    }

    @Generated
    public void setCorrectForDrops(BooleanFeature correctForDrops) {
        this.correctForDrops = correctForDrops;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

