/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.usecooldown;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.jetbrains.annotations.NotNull;

public class UseCooldownFeatures
extends FeatureWithHisOwnEditor<UseCooldownFeatures, UseCooldownFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private UncoloredStringFeature cooldownGroup;
    private IntegerFeature vanillaUseCooldown;

    public UseCooldownFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.useCooldownFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.cooldownGroup = new UncoloredStringFeature(this, Optional.empty(), FeatureSettingsSCore.cooldownGroup, true);
        this.vanillaUseCooldown = new IntegerFeature(this, Optional.empty(), FeatureSettingsSCore.vanillaUseCooldown);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (isPremiumLoading) {
            error.addAll(this.cooldownGroup.load(plugin, config, isPremiumLoading));
            if (((Optional)this.cooldownGroup.getValue()).isPresent()) {
                String group = ((String)((Optional)this.cooldownGroup.getValue()).get()).toLowerCase();
                this.cooldownGroup.setValue(Optional.of(group));
            }
            error.addAll(this.vanillaUseCooldown.load(plugin, config, isPremiumLoading));
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        this.cooldownGroup.save(config);
        this.vanillaUseCooldown.save(config);
    }

    @Override
    public UseCooldownFeatures getValue() {
        return this;
    }

    @Override
    public UseCooldownFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = this.isRequirePremium() && !this.isPremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&7CooldownGroup: &e" + ((Optional)this.cooldownGroup.getValue()).orElse("&cNONE");
        finalDescription[finalDescription.length - 1] = "&7VanillaUseCooldown: &e" + ((Optional)this.vanillaUseCooldown.getValue()).orElse(0);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public UseCooldownFeatures clone(FeatureParentInterface newParent) {
        UseCooldownFeatures dropFeatures = new UseCooldownFeatures(newParent);
        dropFeatures.setCooldownGroup(this.cooldownGroup.clone(dropFeatures));
        dropFeatures.setVanillaUseCooldown(this.vanillaUseCooldown.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.cooldownGroup);
        features.add(this.vanillaUseCooldown);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof UseCooldownFeatures)) continue;
            UseCooldownFeatures dropFeatures = (UseCooldownFeatures)feature;
            dropFeatures.setCooldownGroup(this.cooldownGroup);
            dropFeatures.setVanillaUseCooldown(this.vanillaUseCooldown);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public void applyOnItemMeta(ItemMeta meta) {
        if (SCore.is1v21v2Plus()) {
            boolean oneEdit = false;
            UseCooldownComponent useCooldown = meta.getUseCooldown();
            boolean fixSpigotIssueVanillaUseCooldownMustBeAtLeastOne = false;
            if (((Optional)this.cooldownGroup.getValue()).isPresent()) {
                useCooldown.setCooldownGroup(NamespacedKey.fromString((String)((String)((Optional)this.cooldownGroup.getValue()).get()).toLowerCase()));
                fixSpigotIssueVanillaUseCooldownMustBeAtLeastOne = true;
                oneEdit = true;
            }
            if (((Optional)this.vanillaUseCooldown.getValue()).isPresent() && (Integer)((Optional)this.vanillaUseCooldown.getValue()).get() > 0) {
                useCooldown.setCooldownSeconds((float)((Integer)((Optional)this.vanillaUseCooldown.getValue()).get()).intValue());
                oneEdit = true;
            } else if (fixSpigotIssueVanillaUseCooldownMustBeAtLeastOne) {
                useCooldown.setCooldownSeconds(1.0f);
                oneEdit = true;
            }
            if (oneEdit) {
                meta.setUseCooldown(useCooldown);
            }
        }
    }

    @Generated
    public UncoloredStringFeature getCooldownGroup() {
        return this.cooldownGroup;
    }

    @Generated
    public IntegerFeature getVanillaUseCooldown() {
        return this.vanillaUseCooldown;
    }

    @Generated
    public void setCooldownGroup(UncoloredStringFeature cooldownGroup) {
        this.cooldownGroup = cooldownGroup;
    }

    @Generated
    public void setVanillaUseCooldown(IntegerFeature vanillaUseCooldown) {
        this.vanillaUseCooldown = vanillaUseCooldown;
    }
}

