/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.variables.update.variable;

import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.variables.base.group.VariablesGroupFeature;
import com.ssomar.score.features.custom.variables.base.variable.VariableFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditorReloaded;
import com.ssomar.score.features.editor.GenericFeatureParentEditorReloadedManager;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.VariableUpdateTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectWithVariables;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.VariableType;
import com.ssomar.score.utils.emums.VariableUpdateType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VariableUpdateFeature
extends FeatureWithHisOwnEditor<VariableUpdateFeature, VariableUpdateFeature, GenericFeatureParentEditorReloaded, GenericFeatureParentEditorReloadedManager> {
    private static final boolean DEBUG = false;
    private UncoloredStringFeature variableName;
    private VariableUpdateTypeFeature type;
    private ColoredStringFeature stringUpdate;
    private DoubleFeature doubleUpdate;
    private String id;
    private VariablesGroupFeature features;

    public VariableUpdateFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.variableUpdate);
        this.id = id;
        this.reset();
    }

    public VariableUpdateFeature(String id, VariablesGroupFeature features) {
        super(null, FeatureSettingsSCore.variableUpdate);
        this.id = id;
        this.features = features;
    }

    @Override
    public void reset() {
        this.variableName = new UncoloredStringFeature(this, Optional.of("var"), FeatureSettingsSCore.variableName, false);
        this.type = new VariableUpdateTypeFeature(this, Optional.of(VariableUpdateType.SET), FeatureSettingsSCore.type);
        this.stringUpdate = new ColoredStringFeature(this, Optional.of(""), FeatureSettingsSCore.modification_string);
        this.doubleUpdate = new DoubleFeature(this, Optional.of(0.0), FeatureSettingsSCore.modification_double);
    }

    public VariablesGroupFeature getVariables() {
        FeatureParentInterface parent = this.getParent();
        while (parent instanceof FeatureAbstract) {
            if (parent instanceof SObjectWithVariables) {
                return ((SObjectWithVariables)((Object)parent)).getVariables();
            }
            if (((FeatureAbstract)((Object)parent)).getParent() == parent) break;
            parent = ((FeatureAbstract)((Object)parent)).getParent();
        }
        return null;
    }

    public Optional<VariableFeature> getAssociatedVariable() {
        VariablesGroupFeature variables = null;
        variables = this.features != null ? this.features : this.getVariables();
        if (variables == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(variables.getVariable((String)((Optional)this.variableName.getValue()).get()));
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.variableName.load(plugin, enchantmentConfig, isPremiumLoading));
            if (((Optional)this.variableName.getValue()).isPresent()) {
                if (this.getVariables().getVariablesName().contains(((Optional)this.variableName.getValue()).get())) {
                    errors.addAll(this.type.load(plugin, enchantmentConfig, isPremiumLoading));
                    VariableType variableType = (VariableType)((Optional)this.getVariables().getVariable((String)((Optional)this.variableName.getValue()).get()).getType().getValue()).get();
                    if (variableType.equals(VariableType.STRING) || variableType.equals(VariableType.LIST)) {
                        errors.addAll(this.stringUpdate.load(plugin, enchantmentConfig, isPremiumLoading));
                    } else {
                        errors.addAll(this.doubleUpdate.load(plugin, enchantmentConfig, isPremiumLoading));
                    }
                } else {
                    errors.add("&cERROR, Couldn't load the VariableUpdate with its options (ID: " + this.id + ") because the variable associated (" + (String)((Optional)this.variableName.getValue()).get() + ") doesnt exist &7&o" + this.getParent().getParentInfo());
                }
            } else {
                errors.add("&cERROR, Couldn't load the VariableUpdate with its options (ID: " + this.id + ") because their is not variableName defined ! &7&o" + this.getParent().getParentInfo());
            }
        } else {
            errors.add("&cERROR, Couldn't load the VariableUpdate with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        if (this.getVariables().getVariablesName().contains(((Optional)this.variableName.getValue()).get())) {
            VariableType variableType = (VariableType)((Optional)this.getVariables().getVariable((String)((Optional)this.variableName.getValue()).get()).getType().getValue()).get();
            this.variableName.save(attributeConfig);
            this.type.save(attributeConfig);
            if (variableType.equals(VariableType.STRING) || variableType.equals(VariableType.LIST)) {
                this.stringUpdate.save(attributeConfig);
            } else {
                this.doubleUpdate.save(attributeConfig);
            }
        }
    }

    @Override
    public VariableUpdateFeature getValue() {
        return this;
    }

    @Override
    public VariableUpdateFeature initItemParentEditor(GUI gui, int slot) {
        VariableType variableType;
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = "&7For the var: &e" + (String)((Optional)this.variableName.getValue()).get();
        finalDescription[finalDescription.length - 3] = "&7Type: &e" + ((Optional)this.type.getValue()).get();
        finalDescription[finalDescription.length - 2] = this.getVariables().getVariablesName().contains(((Optional)this.variableName.getValue()).get()) ? ((variableType = (VariableType)((Optional)this.getVariables().getVariable((String)((Optional)this.variableName.getValue()).get()).getType().getValue()).get()).equals(VariableType.STRING) || variableType.equals(VariableType.LIST) ? "&7Update: &e" + (String)((Optional)this.stringUpdate.getValue()).get() : "&7Update: &e" + ((Optional)this.doubleUpdate.getValue()).get()) : "&7Update: &c?";
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public VariableUpdateFeature clone(FeatureParentInterface newParent) {
        VariableUpdateFeature eF = new VariableUpdateFeature(newParent, this.id);
        eF.setVariableName(this.variableName.clone(eF));
        eF.setType(this.type.clone(eF));
        eF.setStringUpdate(this.stringUpdate.clone(eF));
        eF.setDoubleUpdate(this.doubleUpdate.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> featureInterfaces = new ArrayList<FeatureInterface>(Arrays.asList(this.variableName, this.type));
        if (this.getVariables().getVariablesName().contains(((Optional)this.variableName.getValue()).get())) {
            VariableType variableType = (VariableType)((Optional)this.getVariables().getVariable((String)((Optional)this.variableName.getValue()).get()).getType().getValue()).get();
            if (variableType.equals(VariableType.STRING) || variableType.equals(VariableType.LIST)) {
                featureInterfaces.add(this.stringUpdate);
            } else {
                featureInterfaces.add(this.doubleUpdate);
            }
        }
        return featureInterfaces;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            VariableUpdateFeature aFOF;
            if (!(feature instanceof VariableUpdateFeature) || !(aFOF = (VariableUpdateFeature)feature).getId().equals(this.id)) continue;
            aFOF.setVariableName(this.variableName);
            aFOF.setType(this.type);
            aFOF.setStringUpdate(this.stringUpdate);
            aFOF.setDoubleUpdate(this.doubleUpdate);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorReloadedManager.getInstance().startEditing(player, this);
    }

    @Generated
    public UncoloredStringFeature getVariableName() {
        return this.variableName;
    }

    @Generated
    public VariableUpdateTypeFeature getType() {
        return this.type;
    }

    @Generated
    public ColoredStringFeature getStringUpdate() {
        return this.stringUpdate;
    }

    @Generated
    public DoubleFeature getDoubleUpdate() {
        return this.doubleUpdate;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setVariableName(UncoloredStringFeature variableName) {
        this.variableName = variableName;
    }

    @Generated
    public void setType(VariableUpdateTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setStringUpdate(ColoredStringFeature stringUpdate) {
        this.stringUpdate = stringUpdate;
    }

    @Generated
    public void setDoubleUpdate(DoubleFeature doubleUpdate) {
        this.doubleUpdate = doubleUpdate;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setFeatures(VariablesGroupFeature features) {
        this.features = features;
    }
}

