/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeFeature
extends FeatureAbstract<Optional<Attribute>, AttributeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<Attribute> value;
    private Optional<Attribute> defaultValue;

    public AttributeFeature(FeatureParentInterface parent, Optional<Attribute> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String attributeStr = config.getString(this.getName());
        Attribute attribute = null;
        if (SCore.is1v12Less()) {
            errors.add("&cERROR, Couldn't load the Attribute value of " + this.getName() + " from config, value: " + attributeStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Attributes are only available for 1.13+");
            this.value = Optional.empty();
        } else {
            try {
                attribute = AttributeUtils.getAttribute(attributeStr);
                this.value = Optional.of(attribute);
                FeatureReturnCheckPremium<Attribute> checkPremium = this.checkPremium("Attribute", attribute, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Error | Exception e) {
                errors.add("&cERROR, Couldn't load the Attribute value of " + this.getName() + " from config, value: " + attributeStr + " &7&o" + this.getParent().getParentInfo() + " &6>> Attributes available: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/attribute/Attribute.html");
                this.value = Optional.empty();
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object optional = this.getValue();
        if (((Optional)optional).isPresent()) {
            config.set(this.getName(), (Object)AttributeUtils.getAttributes().get(((Optional)optional).get()));
        } else {
            config.set(this.getName(), null);
        }
    }

    @Override
    public Optional<Attribute> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public AttributeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Attribute att = null;
        att = SCore.is1v21v2Plus() ? Attribute.ARMOR : AttributeUtils.getAttribute("GENERIC_ARMOR");
        Object optional = this.getValue();
        if (((Optional)optional).isPresent()) {
            this.updateAttribute((Attribute)((Optional)optional).get(), gui);
        } else {
            this.updateAttribute(att, gui);
        }
    }

    @Override
    public AttributeFeature clone(FeatureParentInterface newParent) {
        AttributeFeature clone = new AttributeFeature(newParent, this.defaultValue, this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        Attribute attribute = this.getAttribute((GUI)manager.getCache().get(editor));
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        attribute = this.nextAttribute(attribute);
        this.updateAttribute(attribute, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        Attribute attribute = this.getAttribute((GUI)manager.getCache().get(editor));
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        attribute = this.prevAttribute(attribute);
        this.updateAttribute(attribute, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateAttribute(this.nextAttribute(this.getAttribute((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateAttribute(this.prevAttribute(this.getAttribute((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public Attribute nextAttribute(Attribute attribute) {
        boolean next = false;
        Map<Object, String> map = AttributeUtils.getAttributes();
        for (Object check : map.keySet()) {
            if (check.equals(attribute)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return (Attribute)check;
        }
        return (Attribute)map.keySet().iterator().next();
    }

    public Attribute prevAttribute(Attribute attribute) {
        int i = -1;
        int cpt = 0;
        Map<Object, String> map = AttributeUtils.getAttributes();
        for (Object check : map.keySet()) {
            if (check.equals(attribute)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return (Attribute)map.keySet().toArray()[map.size() - 1];
        }
        return (Attribute)map.keySet().toArray()[cpt - 1];
    }

    public void updateAttribute(Attribute attribute, GUI gui) {
        this.value = Optional.of(attribute);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        Map<Object, String> map = AttributeUtils.getAttributes();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += map.size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (Object check : map.keySet()) {
            if (attribute == check) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + map.get(attribute)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + map.get(check)));
        }
        for (Object check : map.keySet()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + map.get(check)));
        }
        for (String str : lore) {
            SsomarDev.testMsg(str, true);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Attribute getAttribute(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return AttributeUtils.getAttribute(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    @Generated
    public Optional<Attribute> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<Attribute> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<Attribute> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

