/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ListDetailedEffectFeature
extends FeatureAbstract<List<String>, ListDetailedEffectFeature>
implements FeatureRequireSubTextEditorInEditor {
    private static final String symbolNegation = "!";
    private static final Boolean DEBUG = true;
    private List<String> value;
    private List<String> defaultValue;
    private boolean notSaveIfEqualsToDefaultValue;

    public ListDetailedEffectFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
        this.reset();
    }

    public List<String> load(SPlugin plugin, List<String> entries, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.value = new ArrayList<String>();
        for (String s : entries) {
            String baseValue = StringConverter.decoloredString(s);
            String checkValue = baseValue;
            if (checkValue.startsWith(symbolNegation)) {
                checkValue = checkValue.substring(1);
            }
            String entityTypeStr = checkValue;
            try {
                PotionEffectType.getByName((String)entityTypeStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                errors.add("&cERROR, Couldn't load the EntityType value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> EntityTypes available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/entity/EntityType.html");
                continue;
            }
            this.value.add(baseValue.toUpperCase());
        }
        FeatureReturnCheckPremium<List<String>> checkPremium = this.checkPremium("List of Detailed effects", this.value, Optional.of(this.defaultValue), isPremiumLoading);
        if (checkPremium.isHasError()) {
            this.value = checkPremium.getNewValue();
        }
        return errors;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        return this.load(plugin, config.getStringList(this.getName()), isPremiumLoading);
    }

    public List<String> getWhiteListValues() {
        ArrayList<String> whiteList = new ArrayList<String>();
        for (String s : this.value) {
            if (s.startsWith(symbolNegation)) continue;
            whiteList.add(s);
        }
        return whiteList;
    }

    public List<String> getBlackListValues() {
        ArrayList<String> blackList = new ArrayList<String>();
        for (String s : this.value) {
            if (!s.startsWith(symbolNegation)) continue;
            blackList.add(s.substring(1));
        }
        return blackList;
    }

    public boolean isValidEffect(@NotNull PotionEffectType type) {
        List<String> whiteList = this.getWhiteListValues();
        List<String> blackList = this.getBlackListValues();
        for (String t : blackList) {
            if (!t.toUpperCase().equals(type.getName().toUpperCase())) continue;
            return false;
        }
        if (whiteList.isEmpty()) {
            return true;
        }
        for (String t : whiteList) {
            if (!t.toUpperCase().equals(type.getName().toUpperCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.notSaveIfEqualsToDefaultValue && new HashSet<String>(this.defaultValue).containsAll(this.value)) {
            config.set(this.getName(), null);
            return;
        }
        config.set(this.getName(), this.value);
    }

    public List<String> getValues() {
        return this.value;
    }

    @Override
    public ListDetailedEffectFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        gui.updateConditionList(this.getEditorName(), this.getValues(), "&cEMPTY");
    }

    @Override
    public ListDetailedEffectFeature clone(FeatureParentInterface newParent) {
        ListDetailedEffectFeature clone = new ListDetailedEffectFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isNotSaveIfEqualsToDefaultValue());
        clone.setValue(this.getValues());
        return clone;
    }

    @Override
    public void reset() {
        this.value = new ArrayList<String>(this.defaultValue);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        String s = StringConverter.decoloredString(message);
        if (s.startsWith(symbolNegation)) {
            s = s.substring(1);
        }
        String entityTypeStr = s;
        try {
            PotionEffectType.getByName((String)entityTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered contains an invalid Effect ! (Check the wiki or spigot if you want the list)");
        }
        return Optional.empty();
    }

    @Override
    public List<String> getCurrentValues() {
        return this.value;
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return new ArrayList<Suggestion>();
    }

    @Override
    public String getTips() {
        return "&8Example &7&oSPEED";
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        this.value = manager.currentWriting.get(editor);
        for (int i = 0; i < this.value.size(); ++i) {
            this.value.set(i, StringConverter.decoloredString(this.value.get(i)));
        }
        manager.requestWriting.remove(editor);
        manager.activeTextEditor.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ListDetailedEffectFeature.space(playerEditor);
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Override
    @Generated
    public List<String> getValue() {
        return this.value;
    }

    @Generated
    public List<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isNotSaveIfEqualsToDefaultValue() {
        return this.notSaveIfEqualsToDefaultValue;
    }

    @Generated
    public void setValue(List<String> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(List<String> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setNotSaveIfEqualsToDefaultValue(boolean notSaveIfEqualsToDefaultValue) {
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }
}

