/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ListIntegerFeature
extends ListFeatureAbstract<Integer, ListIntegerFeature> {
    private Optional<List<Suggestion>> suggestions;

    public ListIntegerFeature(FeatureParentInterface parent, List<Integer> defaultValue, FeatureSettingsInterface featureSettings, Optional<List<Suggestion>> suggestions) {
        super(parent, "List of Colored Strings", defaultValue, featureSettings);
        this.suggestions = suggestions;
        this.reset();
    }

    @Override
    public List<Integer> loadValues(List<String> entries, List<String> errors) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String s : entries) {
            ints.add(Integer.valueOf(s));
        }
        return ints;
    }

    @Override
    public String transfromToString(Integer value) {
        return value.toString();
    }

    @Override
    public ListIntegerFeature clone(FeatureParentInterface newParent) {
        ListIntegerFeature clone = new ListIntegerFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.suggestions);
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        try {
            Integer.valueOf(message);
        }
        catch (NumberFormatException e) {
            return Optional.of("This is not a number");
        }
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return this.suggestions.orElseGet(ArrayList::new);
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Generated
    public void setSuggestions(Optional<List<Suggestion>> suggestions) {
        this.suggestions = suggestions;
    }
}

