/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ListMaterialFeature
extends ListFeatureAbstract<Material, ListMaterialFeature> {
    public ListMaterialFeature(FeatureParentInterface parent, List<Material> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of Materials", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<Material> loadValues(List<String> entries, List<String> errors) {
        ArrayList<Material> value = new ArrayList<Material>();
        for (String s : entries) {
            s = StringConverter.decoloredString(s);
            try {
                Material mat = Material.valueOf((String)s.toUpperCase());
                value.add(mat);
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the Material value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> Materials available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html");
            }
        }
        return value;
    }

    @Override
    public String transfromToString(Material value) {
        return value.name();
    }

    @Override
    public ListMaterialFeature clone(FeatureParentInterface newParent) {
        ListMaterialFeature clone = new ListMaterialFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = StringConverter.decoloredString(message);
        try {
            Material mat = Material.valueOf((String)message);
            this.getValues().add(mat);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered is not a Material &6>> Materials available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html");
        }
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        TreeMap<String, Suggestion> map = new TreeMap<String, Suggestion>();
        for (Material mat : Material.values()) {
            map.put(mat.toString(), new Suggestion(mat + "", "&6[&e" + mat + "&6]", "&7Add &e" + mat));
        }
        return new ArrayList<Suggestion>(map.values());
    }

    @Override
    public String getTips() {
        return "&8Example &7&oSTONE";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, true, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

