/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.projectiles.features.visualItemFeature;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.headfeatures.HeadFeatures;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.projectiles.features.visualItemFeature.VisualItemFeatureEditor;
import com.ssomar.score.projectiles.features.visualItemFeature.VisualItemFeatureEditorManager;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VisualItemFeature
extends FeatureWithHisOwnEditor<VisualItemFeature, VisualItemFeature, VisualItemFeatureEditor, VisualItemFeatureEditorManager>
implements SProjectileFeatureInterface {
    private MaterialFeature material;
    private HeadFeatures headFeatures;

    public VisualItemFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.visualItem);
        this.reset();
    }

    @Override
    public void reset() {
        this.headFeatures = new HeadFeatures(this);
        this.material = new MaterialFeature(this, Optional.of(Material.BARRIER), FeatureSettingsSCore.material);
    }

    @Override
    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (((Optional)this.material.getValue()).isPresent() && e instanceof ThrowableProjectile && !((Material)((Optional)this.material.getValue()).get()).equals((Object)Material.BARRIER)) {
            ItemStack item = new ItemStack(this.headFeatures.getHeadOr((Material)((Optional)this.material.getValue()).get()));
            ((ThrowableProjectile)e).setItem(item);
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.material.load(plugin, section, isPremiumLoading));
            errors.addAll(this.headFeatures.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.material.save(section);
        this.headFeatures.save(section);
    }

    @Override
    public VisualItemFeature getValue() {
        return this;
    }

    @Override
    public VisualItemFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = ((Optional)this.material.getValue()).isPresent() && !((Material)((Optional)this.material.getValue()).get()).equals((Object)Material.BARRIER) ? "&7Material: &a&l" + ((Optional)this.material.getValue()).get() : "&7Material: &c&l\u2718";
        gui.createItem(Material.ITEM_FRAME, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public VisualItemFeature clone(FeatureParentInterface newParent) {
        VisualItemFeature clone = new VisualItemFeature(newParent);
        clone.setMaterial(this.material.clone(clone));
        clone.setHeadFeatures(this.headFeatures.clone(clone));
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.material);
        features.add(this.headFeatures);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof VisualItemFeature) || !feature.getName().equals(this.getName())) continue;
            VisualItemFeature hiders = (VisualItemFeature)feature;
            hiders.setHeadFeatures(this.headFeatures);
            hiders.setMaterial(this.material);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openBackEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        VisualItemFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public MaterialFeature getMaterial() {
        return this.material;
    }

    @Generated
    public HeadFeatures getHeadFeatures() {
        return this.headFeatures;
    }

    @Generated
    public void setMaterial(MaterialFeature material) {
        this.material = material;
    }

    @Generated
    public void setHeadFeatures(HeadFeatures headFeatures) {
        this.headFeatures = headFeatures;
    }
}

