/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.equip.armor;

import com.ssomar.sevents.events.player.equip.armor.PlayerEquipArmorListener;
import com.ssomar.sevents.version.Version;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;

public enum ArmorType {
    HELMET(5),
    CHESTPLATE(6),
    LEGGINGS(7),
    BOOTS(8);

    private final int slot;

    private ArmorType(int slot) {
        this.slot = slot;
    }

    public static ArmorType matchType(ItemStack itemStack, boolean noHead) {
        if (PlayerEquipArmorListener.isAirOrNull(itemStack)) {
            return null;
        }
        String type = itemStack.getType().name();
        if (!noHead && (type.endsWith("_SKULL") || type.endsWith("_HEAD"))) {
            return HELMET;
        }
        if (type.endsWith("_HELMET")) {
            return HELMET;
        }
        if (type.endsWith("_CHESTPLATE") || type.equals("ELYTRA")) {
            return CHESTPLATE;
        }
        if (type.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (type.endsWith("_BOOTS")) {
            return BOOTS;
        }
        if (type.equals("CARVED_PUMPKIN")) {
            return HELMET;
        }
        if (Version.is1v21v3Plus()) {
            if (itemStack.hasItemMeta()) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta.hasEquippable()) {
                    EquippableComponent equippable = itemMeta.getEquippable();
                    switch (equippable.getSlot()) {
                        case HEAD: {
                            return HELMET;
                        }
                        case CHEST: {
                            return CHESTPLATE;
                        }
                        case LEGS: {
                            return LEGGINGS;
                        }
                        case FEET: {
                            return BOOTS;
                        }
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean canReplaceUsingHotBar(ItemStack itemStack) {
        if (PlayerEquipArmorListener.isAirOrNull(itemStack)) {
            return false;
        }
        String type = itemStack.getType().name();
        return !type.equals("CARVED_PUMPKIN");
    }

    public int getSlot() {
        return this.slot;
    }
}

