/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.registration;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Registration {
    private JavaPlugin host;
    private List<JavaPlugin> plugins;
    private List<Listener> listener;

    public Registration(JavaPlugin plugin, List<Listener> listener) {
        this.host = plugin;
        this.plugins = new ArrayList<JavaPlugin>();
        this.listener = listener;
    }

    public boolean isHost(JavaPlugin plugin) {
        return this.host.equals((Object)plugin);
    }

    public boolean transferHost() {
        if (this.size() > 0) {
            this.unregister();
            this.host = this.plugins.get(0);
            this.register();
            return true;
        }
        return false;
    }

    public void register() {
        for (Listener l : this.listener) {
            this.host.getServer().getPluginManager().registerEvents(l, (Plugin)this.host);
        }
    }

    public void unregister() {
        for (Listener l : this.listener) {
            HandlerList.unregisterAll((Listener)l);
        }
    }

    public List<Listener> getListener() {
        return this.listener;
    }

    public int size() {
        return this.plugins.size();
    }

    public boolean contains(JavaPlugin plugin) {
        return this.plugins.contains(plugin);
    }

    public void addPlugin(JavaPlugin plugin) {
        this.plugins.add(plugin);
    }

    public boolean removePlugin(JavaPlugin plugin) {
        this.plugins.remove(plugin);
        return this.plugins.size() == 0;
    }
}

