/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.commands.runnable.CommandManager;
import com.ssomar.score.commands.runnable.SCommand;
import com.ssomar.score.commands.runnable.block.BlockCommandManager;
import com.ssomar.score.commands.runnable.entity.EntityCommandManager;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommandsManager;
import com.ssomar.score.commands.runnable.player.PlayerCommandManager;
import java.util.ArrayList;
import java.util.List;

public class AllCommandsManager
extends CommandManager<SCommand> {
    private static AllCommandsManager instance;
    private List<String> commandsThatRunCommandsNames;

    public AllCommandsManager() {
        ArrayList commands = new ArrayList();
        commands.addAll(MixedCommandsManager.getInstance().getCommands());
        commands.addAll(PlayerCommandManager.getInstance().getCommands());
        commands.addAll(EntityCommandManager.getInstance().getCommands());
        commands.addAll(BlockCommandManager.getInstance().getCommands());
        commands.sort((c1, c2) -> {
            if (c1.getPriority() < c2.getPriority()) {
                return 1;
            }
            if (c1.getPriority() > c2.getPriority()) {
                return -1;
            }
            return 0;
        });
        this.setCommands(commands);
        this.commandsThatRunCommandsNames = new ArrayList<String>();
        for (SCommand command : commands) {
            if (!command.isCanExecuteCommands()) continue;
            this.commandsThatRunCommandsNames.addAll(command.getNames());
        }
    }

    public boolean startsWithCommandThatRunCommands(String command) {
        for (String cmd : this.commandsThatRunCommandsNames) {
            if (!command.startsWith(cmd)) continue;
            return true;
        }
        return false;
    }

    public static AllCommandsManager getInstance() {
        if (instance == null) {
            instance = new AllCommandsManager();
        }
        return instance;
    }
}

